/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.alluxio;

import alluxio.grpc.table.BinaryColumnStatsData;
import alluxio.grpc.table.BooleanColumnStatsData;
import alluxio.grpc.table.ColumnStatisticsData;
import alluxio.grpc.table.Date;
import alluxio.grpc.table.DateColumnStatsData;
import alluxio.grpc.table.Decimal;
import alluxio.grpc.table.DecimalColumnStatsData;
import alluxio.grpc.table.DoubleColumnStatsData;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.LongColumnStatsData;
import alluxio.grpc.table.PrincipalType;
import alluxio.grpc.table.StringColumnStatsData;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.grpc.table.layout.hive.SortingColumn;
import alluxio.grpc.table.layout.hive.Storage;
import alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException;
import alluxio.table.ProtoUtils;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;

public class AlluxioProtoUtils {
    private AlluxioProtoUtils() {
    }

    public static Database fromProto(alluxio.grpc.table.Database database) {
        return Database.builder().setDatabaseName(database.getDbName()).setLocation(database.hasLocation() ? Optional.of(database.getLocation()) : Optional.empty()).setOwnerName(database.getOwnerName()).setOwnerType(database.getOwnerType() == PrincipalType.USER ? com.facebook.presto.spi.security.PrincipalType.USER : com.facebook.presto.spi.security.PrincipalType.ROLE).setComment(database.hasComment() ? Optional.of(database.getComment()) : Optional.empty()).setParameters(database.getParameterMap()).build();
    }

    public static Table fromProto(TableInfo table) {
        if (!table.hasLayout()) {
            throw new UnsupportedOperationException("Unsupported table metadata. missing layout.");
        }
        Layout layout = table.getLayout();
        if (!ProtoUtils.isHiveLayout(layout)) {
            throw new UnsupportedOperationException("Unsupported table layout: " + layout);
        }
        try {
            PartitionInfo partitionInfo = ProtoUtils.toHiveLayout(layout);
            Set partitionColumns = table.getPartitionColsList().stream().map(FieldSchema::getName).collect(ImmutableSet.toImmutableSet());
            List dataColumns = table.getSchema().getColsList().stream().filter(field -> !partitionColumns.contains(field.getName())).collect(ImmutableList.toImmutableList());
            Table.Builder builder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(table.getOwner()).setTableType(PrestoTableType.OTHER).setDataColumns(dataColumns.stream().map(AlluxioProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setPartitionColumns(table.getPartitionColsList().stream().map(AlluxioProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setParameters(table.getParametersMap()).setViewOriginalText(Optional.empty()).setViewExpandedText(Optional.empty());
            Storage storage = partitionInfo.getStorage();
            builder.getStorageBuilder().setSkewed(storage.getSkewed()).setStorageFormat(AlluxioProtoUtils.fromProto(storage.getStorageFormat())).setLocation(storage.getLocation()).setBucketProperty(storage.hasBucketProperty() ? AlluxioProtoUtils.fromProto(storage.getBucketProperty()) : Optional.empty()).setSerdeParameters(storage.getStorageFormat().getSerdelibParametersMap());
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed to extract PartitionInfo from TableInfo", e);
        }
    }

    public static HiveColumnStatistics fromProto(ColumnStatisticsData columnStatistics, OptionalLong rowCount) {
        if (columnStatistics.hasLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getLongStats();
            OptionalLong min2 = longStatsData.hasLowValue() ? OptionalLong.of(longStatsData.getLowValue()) : OptionalLong.empty();
            OptionalLong max = longStatsData.hasHighValue() ? OptionalLong.of(longStatsData.getHighValue()) : OptionalLong.empty();
            OptionalLong nullsCount = longStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(longStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = longStatsData.hasNumDistincts() ? OptionalLong.of(longStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createIntegerColumnStatistics(min2, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getDoubleStats();
            OptionalDouble min3 = doubleStatsData.hasLowValue() ? OptionalDouble.of(doubleStatsData.getLowValue()) : OptionalDouble.empty();
            OptionalDouble max = doubleStatsData.hasHighValue() ? OptionalDouble.of(doubleStatsData.getHighValue()) : OptionalDouble.empty();
            OptionalLong nullsCount = doubleStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(doubleStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = doubleStatsData.hasNumDistincts() ? OptionalLong.of(doubleStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDoubleColumnStatistics(min3, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getDecimalStats();
            Optional<BigDecimal> min4 = decimalStatsData.hasLowValue() ? AlluxioProtoUtils.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty();
            Optional<BigDecimal> max = decimalStatsData.hasHighValue() ? AlluxioProtoUtils.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = decimalStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(decimalStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = decimalStatsData.hasNumDistincts() ? OptionalLong.of(decimalStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDecimalColumnStatistics(min4, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getDateStats();
            Optional<LocalDate> min5 = dateStatsData.hasLowValue() ? AlluxioProtoUtils.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty();
            Optional<LocalDate> max = dateStatsData.hasHighValue() ? AlluxioProtoUtils.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = dateStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(dateStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = dateStatsData.hasNumDistincts() ? OptionalLong.of(dateStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createDateColumnStatistics(min5, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getBooleanStats();
            OptionalLong trueCount = OptionalLong.empty();
            OptionalLong falseCount = OptionalLong.empty();
            if (booleanStatsData.hasNumTrues() && booleanStatsData.hasNumFalses() && booleanStatsData.getNumFalses() != -1L) {
                trueCount = OptionalLong.of(booleanStatsData.getNumTrues());
                falseCount = OptionalLong.of(booleanStatsData.getNumFalses());
            }
            return HiveColumnStatistics.createBooleanColumnStatistics(trueCount, falseCount, booleanStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(booleanStatsData.getNumNulls()) : OptionalLong.empty());
        }
        if (columnStatistics.hasStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStringStats();
            OptionalLong maxColumnLength = stringStatsData.hasMaxColLen() ? OptionalLong.of(stringStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = stringStatsData.hasAvgColLen() ? OptionalDouble.of(stringStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = stringStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(stringStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = stringStatsData.hasNumDistincts() ? OptionalLong.of(stringStatsData.getNumDistincts()) : OptionalLong.empty();
            return HiveColumnStatistics.createStringColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.hasBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getBinaryStats();
            OptionalLong maxColumnLength = binaryStatsData.hasMaxColLen() ? OptionalLong.of(binaryStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = binaryStatsData.hasAvgColLen() ? OptionalDouble.of(binaryStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = binaryStatsData.hasNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(binaryStatsData.getNumNulls()) : OptionalLong.empty();
            return HiveColumnStatistics.createBinaryColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + columnStatistics);
    }

    private static Column fromProto(FieldSchema column) {
        Optional<String> comment = column.hasComment() ? Optional.of(column.getComment()) : Optional.empty();
        return new Column(column.getName(), HiveType.valueOf(column.getType()), comment);
    }

    public static Partition fromProto(PartitionInfo info) {
        Partition.Builder builder = Partition.builder().setColumns(info.getDataColsList().stream().map(AlluxioProtoUtils::fromProto).collect(ImmutableList.toImmutableList())).setDatabaseName(info.getDbName()).setParameters(info.getParametersMap()).setValues(Lists.newArrayList(info.getValuesList())).setTableName(info.getTableName());
        builder.getStorageBuilder().setSkewed(info.getStorage().getSkewed()).setStorageFormat(AlluxioProtoUtils.fromProto(info.getStorage().getStorageFormat())).setLocation(info.getStorage().getLocation()).setBucketProperty(info.getStorage().hasBucketProperty() ? AlluxioProtoUtils.fromProto(info.getStorage().getBucketProperty()) : Optional.empty()).setSerdeParameters(info.getStorage().getStorageFormat().getSerdelibParametersMap());
        return builder.build();
    }

    public static StorageFormat fromProto(alluxio.grpc.table.layout.hive.StorageFormat format) {
        return StorageFormat.create(format.getSerde(), format.getInputFormat(), format.getOutputFormat());
    }

    public static PartitionInfo toPartitionInfo(alluxio.grpc.table.Partition part) {
        try {
            return ProtoUtils.extractHiveLayout(part);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed to extract PartitionInfo", e);
        }
    }

    public static List<PartitionInfo> toPartitionInfoList(List<alluxio.grpc.table.Partition> parts) {
        return parts.stream().map(AlluxioProtoUtils::toPartitionInfo).collect(ImmutableList.toImmutableList());
    }

    private static SortingColumn fromProto(alluxio.grpc.table.layout.hive.SortingColumn column) {
        if (column.getOrder().equals(SortingColumn.SortingOrder.ASCENDING)) {
            return new SortingColumn(column.getColumnName(), SortingColumn.Order.ASCENDING);
        }
        if (column.getOrder().equals(SortingColumn.SortingOrder.DESCENDING)) {
            return new SortingColumn(column.getColumnName(), SortingColumn.Order.DESCENDING);
        }
        throw new IllegalArgumentException("Invalid sort order: " + column.getOrder());
    }

    private static Optional<HiveBucketProperty> fromProto(alluxio.grpc.table.layout.hive.HiveBucketProperty property) {
        if (!property.hasBucketCount() || property.getBucketCount() <= 0L) {
            return Optional.empty();
        }
        List sortedBy = property.getSortedByList().stream().map(AlluxioProtoUtils::fromProto).collect(ImmutableList.toImmutableList());
        return Optional.of(new HiveBucketProperty(property.getBucketedByList(), (int)property.getBucketCount(), sortedBy, BucketFunctionType.HIVE_COMPATIBLE, Optional.empty()));
    }

    private static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled().toByteArray()), decimal.getScale()));
    }

    private static Optional<LocalDate> fromMetastoreDate(@Nullable Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }
}

