/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.alluxio;

import alluxio.ClientContext;
import alluxio.client.table.RetryHandlingTableMasterClient;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.alluxio.AlluxioHiveMetastore;
import com.facebook.presto.hive.metastore.alluxio.AlluxioHiveMetastoreConfig;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class AlluxioMetastoreModule
extends AbstractConfigurationAwareModule {
    @Override
    protected void setup(Binder binder) {
        ConfigBinder.configBinder(binder).bindConfig(AlluxioHiveMetastoreConfig.class);
        binder.bind(ExtendedHiveMetastore.class).to(AlluxioHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter(binder).export(ExtendedHiveMetastore.class).as(ObjectNames.generatedNameOf(AlluxioHiveMetastore.class));
    }

    @Provides
    @Inject
    TableMasterClient provideCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        String address = config.getMasterAddress();
        String[] parts = address.split(":", 2);
        conf.set(PropertyKey.MASTER_HOSTNAME, parts[0]);
        if (parts.length > 1) {
            conf.set(PropertyKey.MASTER_RPC_PORT, parts[1]);
        }
        MasterClientContext context = MasterClientContext.newBuilder(ClientContext.create(conf)).build();
        return new RetryHandlingTableMasterClient(context);
    }
}

