/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.TableOfflineException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MetastoreUtil {
    public static final String PRESTO_OFFLINE = "presto_offline";
    public static final String AVRO_SCHEMA_URL_KEY = "avro.schema.url";
    public static final String PRESTO_VIEW_FLAG = "presto_view";
    public static final String PRESTO_MATERIALIZED_VIEW_FLAG = "presto_materialized_view";
    public static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    public static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    public static final FsPermission ALL_PERMISSIONS = new FsPermission(511);
    private static final String PARTITION_VALUE_WILDCARD = "";
    private static final String NUM_FILES = "numFiles";
    private static final String NUM_ROWS = "numRows";
    private static final String RAW_DATA_SIZE = "rawDataSize";
    private static final String TOTAL_SIZE = "totalSize";
    private static final Set<String> STATS_PROPERTIES = ImmutableSet.of("numFiles", "numRows", "rawDataSize", "totalSize");

    private MetastoreUtil() {
    }

    public static boolean isArrayType(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    public static boolean isMapType(Type type) {
        return type.getTypeSignature().getBase().equals("map");
    }

    public static boolean isRowType(Type type) {
        return type.getTypeSignature().getBase().equals("row");
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static Properties getHiveSchema(Table table) {
        return MetastoreUtil.getHiveSchema(table.getStorage(), table.getDataColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    public static Properties getHiveSchema(Partition partition, Table table) {
        return MetastoreUtil.getHiveSchema(partition.getStorage(), partition.getColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    public static Properties getHiveSchema(Storage storage, List<Column> partitionDataColumns, List<Column> tableDataColumns, Map<String, String> tableParameters, String databaseName, String tableName, List<Column> partitionKeys) {
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", storage.getStorageFormat().getInputFormat());
        schema.setProperty("file.outputformat", storage.getStorageFormat().getOutputFormat());
        schema.setProperty("name", databaseName + "." + tableName);
        schema.setProperty("location", storage.getLocation());
        if (storage.getBucketProperty().isPresent()) {
            List<String> bucketedBy = storage.getBucketProperty().get().getBucketedBy();
            if (!bucketedBy.isEmpty()) {
                schema.setProperty("bucket_field_name", Joiner.on(",").join(bucketedBy));
            }
            schema.setProperty("bucket_count", Integer.toString(storage.getBucketProperty().get().getBucketCount()));
        } else {
            schema.setProperty("bucket_count", "0");
        }
        for (Map.Entry entry : storage.getSerdeParameters().entrySet()) {
            schema.setProperty((String)entry.getKey(), entry.getValue() != null ? (String)entry.getValue() : PARTITION_VALUE_WILDCARD);
        }
        schema.setProperty("serialization.lib", storage.getStorageFormat().getSerDe());
        StringBuilder columnNameBuilder = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder columnCommentBuilder = new StringBuilder();
        boolean first = true;
        for (Column column : tableDataColumns) {
            if (!first) {
                columnNameBuilder.append(",");
                stringBuilder.append(":");
                columnCommentBuilder.append('\u0000');
            }
            columnNameBuilder.append(column.getName());
            stringBuilder.append(column.getType());
            columnCommentBuilder.append(column.getComment().orElse(PARTITION_VALUE_WILDCARD));
            first = false;
        }
        String columnNames = columnNameBuilder.toString();
        String columnTypes = stringBuilder.toString();
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypes);
        schema.setProperty("columns.comments", columnCommentBuilder.toString());
        schema.setProperty("serialization.ddl", MetastoreUtil.toThriftDdl(tableName, partitionDataColumns));
        String partString = PARTITION_VALUE_WILDCARD;
        String partStringSep = PARTITION_VALUE_WILDCARD;
        String partTypesString = PARTITION_VALUE_WILDCARD;
        String partTypesStringSep = PARTITION_VALUE_WILDCARD;
        for (Column column : partitionKeys) {
            partString = partString + partStringSep;
            partString = partString + column.getName();
            partTypesString = partTypesString + partTypesStringSep;
            partTypesString = partTypesString + column.getType().getHiveTypeName().toString();
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
            partTypesStringSep = ":";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString);
            schema.setProperty("partition_columns.types", partTypesString);
        }
        if (tableParameters != null) {
            for (Map.Entry entry : tableParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static Properties getHiveSchema(Map<String, String> serdeParameters, Map<String, String> tableParameters) {
        Properties schema = new Properties();
        for (Map.Entry<String, String> param : serdeParameters.entrySet()) {
            schema.setProperty(param.getKey(), param.getValue() != null ? param.getValue() : PARTITION_VALUE_WILDCARD);
        }
        for (Map.Entry<String, String> entry : tableParameters.entrySet()) {
            if (entry.getValue() == null) continue;
            schema.setProperty(entry.getKey(), entry.getValue());
        }
        return schema;
    }

    public static List<Column> reconstructPartitionSchema(List<Column> tableSchema, int partitionColumnCount, Map<Integer, Column> partitionSchemaDifference, Optional<Map<Integer, Integer>> tableToPartitionColumns) {
        ImmutableList.Builder columns = ImmutableList.builder();
        if (tableToPartitionColumns.isPresent()) {
            Map<Integer, Integer> partitionToTableColumns = tableToPartitionColumns.get().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            for (int i = 0; i < partitionColumnCount; ++i) {
                Column column = partitionSchemaDifference.get(i);
                if (column == null) {
                    column = tableSchema.get(partitionToTableColumns.get(i));
                }
                columns.add(column);
            }
        } else {
            for (int i = 0; i < partitionColumnCount; ++i) {
                Column column = partitionSchemaDifference.get(i);
                if (column == null) {
                    Preconditions.checkArgument(i < tableSchema.size(), "column descriptor for column with hiveColumnIndex %s not found: tableSchema: %s, partitionSchemaDifference: %s", (Object)i, tableSchema, partitionSchemaDifference);
                    column = tableSchema.get(i);
                }
                columns.add(column);
            }
        }
        return columns.build();
    }

    public static ProtectMode getProtectMode(Partition partition) {
        return MetastoreUtil.getProtectMode(partition.getParameters());
    }

    public static ProtectMode getProtectMode(Table table) {
        return MetastoreUtil.getProtectMode(table.getParameters());
    }

    public static String makePartName(List<Column> partitionColumns, List<String> values) {
        Preconditions.checkArgument(partitionColumns.size() == values.size(), "Partition value count does not match the partition column count");
        Preconditions.checkArgument(values.stream().allMatch(Objects::nonNull), "partitionValue must not have null elements");
        List partitionColumnNames = partitionColumns.stream().map(Column::getName).collect(Collectors.toList());
        return FileUtils.makePartName(partitionColumnNames, values);
    }

    public static String getPartitionLocation(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return table.getStorage().getLocation();
        }
        return partition.get().getStorage().getLocation();
    }

    private static String toThriftDdl(String structName, List<Column> columns) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(ColumnType.typeToThriftType((String)column.getType().getHiveTypeName().toString()));
            ddl.append(' ');
            ddl.append(column.getName());
        }
        ddl.append("}");
        return ddl.toString();
    }

    private static ProtectMode getProtectMode(Map<String, String> parameters) {
        if (!parameters.containsKey(ProtectMode.PARAMETER_NAME)) {
            return new ProtectMode();
        }
        return ProtectMode.getProtectModeFromString((String)parameters.get(ProtectMode.PARAMETER_NAME));
    }

    public static void verifyOnline(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters) {
        if (protectMode.offline) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), false, null);
            }
            throw new TableOfflineException(tableName, false, null);
        }
        String prestoOffline = parameters.get(PRESTO_OFFLINE);
        if (!Strings.isNullOrEmpty(prestoOffline)) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), true, prestoOffline);
            }
            throw new TableOfflineException(tableName, true, prestoOffline);
        }
    }

    public static void verifyCanDropColumn(ExtendedHiveMetastore metastore, MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        Table table = metastore.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getPartitionColumns().stream().anyMatch(column -> column.getName().equals(columnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition columns");
        }
        if (table.getDataColumns().size() <= 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only non-partition column in a table");
        }
    }

    public static FileSystem getFileSystem(HdfsEnvironment hdfsEnvironment, HdfsContext context, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error getting file system. Path: %s", path), (Throwable)e);
        }
    }

    public static void renameFile(FileSystem fileSystem, Path source, Path target) {
        try {
            if (fileSystem.exists(target) || !fileSystem.rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, MetastoreUtil.getRenameErrorMessage(source, target));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, MetastoreUtil.getRenameErrorMessage(source, target), (Throwable)e);
        }
    }

    public static Map<String, String> toPartitionNamesAndValues(String partitionName) {
        ImmutableMap.Builder<String, String> resultBuilder = ImmutableMap.builder();
        int index = 0;
        int length = partitionName.length();
        while (index < length) {
            int keyStart = index;
            while (index < length && partitionName.charAt(index) != '=') {
                ++index;
            }
            Preconditions.checkState(index < length, "Invalid partition spec: " + partitionName);
            int keyEnd = index++;
            int valueStart = index;
            while (index < length && partitionName.charAt(index) != '/') {
                ++index;
            }
            int valueEnd = index++;
            String key = FileUtils.unescapePathName((String)partitionName.substring(keyStart, keyEnd));
            String value = FileUtils.unescapePathName((String)partitionName.substring(valueStart, valueEnd));
            resultBuilder.put(key, value);
        }
        return resultBuilder.build();
    }

    public static List<String> toPartitionValues(String partitionName) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        int start = 0;
        while (true) {
            int end;
            if (start < partitionName.length() && partitionName.charAt(start) != '=') {
                ++start;
                continue;
            }
            for (end = ++start; end < partitionName.length() && partitionName.charAt(end) != '/'; ++end) {
            }
            if (start > partitionName.length()) break;
            resultBuilder.add(FileUtils.unescapePathName((String)partitionName.substring(start, end)));
            start = end + 1;
        }
        return resultBuilder.build();
    }

    public static List<String> extractPartitionValues(String partitionName) {
        return MetastoreUtil.extractPartitionValues(partitionName, Optional.empty());
    }

    public static List<String> extractPartitionValues(String partitionName, Optional<List<String>> partitionColumnNames) {
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableList.Builder keys = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        int keyStart = 0;
        int keyEnd = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument(current != '/', "Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                keyEnd = i;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument(valueStart != -1, "Invalid partition spec: %s", (Object)partitionName);
            values.add(FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            keys.add(FileUtils.unescapePathName((String)partitionName.substring(keyStart, keyEnd)));
            inKey = true;
            valueStart = -1;
            keyStart = i + 1;
        }
        Preconditions.checkArgument(!inKey, "Invalid partition spec: %s", (Object)partitionName);
        values.add(FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        keys.add(FileUtils.unescapePathName((String)partitionName.substring(keyStart, keyEnd)));
        if (!partitionColumnNames.isPresent() || partitionColumnNames.get().size() == 1) {
            return values.build();
        }
        ImmutableList.Builder orderedValues = ImmutableList.builder();
        partitionColumnNames.get().forEach(columnName -> orderedValues.add(values.build().get(((ImmutableList)keys.build()).indexOf(columnName))));
        return orderedValues.build();
    }

    public static List<String> createPartitionValues(List<Type> partitionColumnTypes, Page partitionColumns, int position) {
        ImmutableList.Builder partitionValues = ImmutableList.builder();
        for (int field = 0; field < partitionColumns.getChannelCount(); ++field) {
            Object value = MetastoreUtil.getField(partitionColumnTypes.get(field), partitionColumns.getBlock(field), position);
            if (value == null) {
                partitionValues.add(HIVE_DEFAULT_DYNAMIC_PARTITION);
                continue;
            }
            String valueString = value.toString();
            if (!CharMatcher.inRange(' ', '~').matchesAllOf(valueString)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "Hive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: " + BaseEncoding.base16().withSeparator(" ", 2).encode(valueString.getBytes(StandardCharsets.UTF_8)));
            }
            partitionValues.add(valueString);
        }
        return partitionValues.build();
    }

    public static Object getField(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals(type)) {
            return type.getBoolean(block, position);
        }
        if (BigintType.BIGINT.equals(type)) {
            return type.getLong(block, position);
        }
        if (IntegerType.INTEGER.equals(type)) {
            return (int)type.getLong(block, position);
        }
        if (SmallintType.SMALLINT.equals(type)) {
            return (short)type.getLong(block, position);
        }
        if (TinyintType.TINYINT.equals(type)) {
            return (byte)type.getLong(block, position);
        }
        if (RealType.REAL.equals(type)) {
            return Float.valueOf(Float.intBitsToFloat((int)type.getLong(block, position)));
        }
        if (DoubleType.DOUBLE.equals(type)) {
            return type.getDouble(block, position);
        }
        if (type instanceof VarcharType) {
            return new Text(type.getSlice(block, position).getBytes());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return new Text(Strings.padEnd(type.getSlice(block, position).toStringUtf8(), charType.getLength(), ' '));
        }
        if (VarbinaryType.VARBINARY.equals(type)) {
            return type.getSlice(block, position).getBytes();
        }
        if (DateType.DATE.equals(type)) {
            long days = type.getLong(block, position);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), TimeUnit.DAYS.toMillis(days)));
        }
        if (TimestampType.TIMESTAMP.equals(type)) {
            long millisUtc = type.getLong(block, position);
            return new Timestamp(millisUtc);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return MetastoreUtil.getHiveDecimal(decimalType, block, position);
        }
        if (MetastoreUtil.isArrayType(type)) {
            Type elementType = type.getTypeParameters().get(0);
            Block arrayBlock = block.getBlock(position);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = MetastoreUtil.getField(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (MetastoreUtil.isMapType(type)) {
            Type keyType = type.getTypeParameters().get(0);
            Type valueType = type.getTypeParameters().get(1);
            Block mapBlock = block.getBlock(position);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = MetastoreUtil.getField(keyType, mapBlock, i);
                Object value = MetastoreUtil.getField(valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        if (MetastoreUtil.isRowType(type)) {
            Block rowBlock = block.getBlock(position);
            List<Type> fieldTypes = type.getTypeParameters();
            MetastoreUtil.checkCondition(fieldTypes.size() == rowBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count", new Object[0]);
            ArrayList<Object> row = new ArrayList<Object>(rowBlock.getPositionCount());
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                Object element = MetastoreUtil.getField(fieldTypes.get(i), rowBlock, i);
                row.add(element);
            }
            return Collections.unmodifiableList(row);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    public static HiveDecimal getHiveDecimal(DecimalType decimalType, Block block, int position) {
        BigInteger unscaledValue = decimalType.isShort() ? BigInteger.valueOf(decimalType.getLong(block, position)) : Decimals.decodeUnscaledValue(decimalType.getSlice(block, position));
        return HiveDecimal.create((BigInteger)unscaledValue, (int)decimalType.getScale());
    }

    public static void createDirectory(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            if (!hdfsEnvironment.getFileSystem(context, path).mkdirs(path, ALL_PERMISSIONS)) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + path, (Throwable)e);
        }
        try {
            hdfsEnvironment.getFileSystem(context, path).setPermission(path, ALL_PERMISSIONS);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to set permission on directory: " + path, (Throwable)e);
        }
    }

    public static boolean pathExists(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(context, path).exists(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static boolean isPrestoView(Table table) {
        return "true".equals(table.getParameters().get(PRESTO_VIEW_FLAG));
    }

    public static boolean isPrestoMaterializedView(Table table) {
        if ("true".equals(table.getParameters().get(PRESTO_MATERIALIZED_VIEW_FLAG))) {
            Preconditions.checkState(table.getViewOriginalText().map(Strings::isNullOrEmpty).orElse(true) == false, "viewOriginalText field is not set for the Table metadata of materialized view %s.", (Object)table.getTableName());
            return true;
        }
        return false;
    }

    private static String getRenameErrorMessage(Path source, Path target) {
        return String.format("Error moving data files from %s to final location %s", source, target);
    }

    public static List<String> convertPredicateToParts(Map<Column, Domain> partitionPredicates) {
        ArrayList<String> filter = new ArrayList<String>();
        for (Map.Entry<Column, Domain> partitionPredicate : partitionPredicates.entrySet()) {
            Domain domain = partitionPredicate.getValue();
            if (!domain.isAll()) {
                if (domain != null && domain.isNullableSingleValue()) {
                    Object value = domain.getNullableSingleValue();
                    Type type = domain.getType();
                    filter.add(MetastoreUtil.convertRawValueToString(value, type));
                    continue;
                }
                filter.add(PARTITION_VALUE_WILDCARD);
                continue;
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        return filter;
    }

    public static String convertRawValueToString(Object value, Type type) {
        String val;
        if (value == null) {
            val = HIVE_DEFAULT_DYNAMIC_PARTITION;
        } else if (type instanceof CharType) {
            Slice slice = (Slice)value;
            val = Chars.padSpaces(slice, type).toStringUtf8();
        } else if (type instanceof VarcharType) {
            Slice slice = (Slice)value;
            val = slice.toStringUtf8();
        } else if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
            Slice slice = (Slice)value;
            val = Decimals.toString(slice, ((DecimalType)type).getScale());
        } else if (type instanceof DecimalType && ((DecimalType)type).isShort()) {
            val = Decimals.toString((Long)value, ((DecimalType)type).getScale());
        } else if (type instanceof DateType) {
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.date().withZoneUTC();
            val = dateTimeFormatter.print(TimeUnit.DAYS.toMillis((Long)value));
        } else if (type instanceof TimestampType) {
            val = PARTITION_VALUE_WILDCARD;
        } else if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof DoubleType || type instanceof RealType || type instanceof BooleanType) {
            val = value.toString();
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
        }
        return val;
    }

    public static OptionalLong fromMetastoreDistinctValuesCount(OptionalLong distinctValuesCount, OptionalLong nullsCount, OptionalLong rowCount) {
        if (distinctValuesCount.isPresent() && nullsCount.isPresent() && rowCount.isPresent()) {
            return OptionalLong.of(MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount.getAsLong(), nullsCount.getAsLong(), rowCount.getAsLong()));
        }
        return OptionalLong.empty();
    }

    public static long fromMetastoreDistinctValuesCount(long distinctValuesCount, long nullsCount, long rowCount) {
        long nonNullsCount = rowCount - nullsCount;
        if (nullsCount > 0L && distinctValuesCount > 0L) {
            --distinctValuesCount;
        }
        if (nonNullsCount > 0L && distinctValuesCount == 0L) {
            distinctValuesCount = 1L;
        }
        if (distinctValuesCount > nonNullsCount) {
            return nonNullsCount;
        }
        return distinctValuesCount;
    }

    public static Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return ImmutableSet.of(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, ColumnStatisticType.NUMBER_OF_TRUE_VALUES);
        }
        if (TypeUtils.isNumericType(type) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP)) {
            return ImmutableSet.of(ColumnStatisticType.MIN_VALUE, ColumnStatisticType.MAX_VALUE, ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES);
        }
        if (Varchars.isVarcharType(type) || Chars.isCharType(type)) {
            return ImmutableSet.of(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, ColumnStatisticType.TOTAL_SIZE_IN_BYTES, ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ImmutableSet.of(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, ColumnStatisticType.TOTAL_SIZE_IN_BYTES, ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type instanceof ArrayType || type instanceof RowType || type instanceof MapType) {
            return ImmutableSet.of(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, ColumnStatisticType.TOTAL_SIZE_IN_BYTES);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static HiveBasicStatistics getHiveBasicStatistics(Map<String, String> parameters) {
        OptionalLong numFiles = MetastoreUtil.parse(parameters.get(NUM_FILES));
        OptionalLong numRows = MetastoreUtil.parse(parameters.get(NUM_ROWS));
        OptionalLong inMemoryDataSizeInBytes = MetastoreUtil.parse(parameters.get(RAW_DATA_SIZE));
        OptionalLong onDiskDataSizeInBytes = MetastoreUtil.parse(parameters.get(TOTAL_SIZE));
        return new HiveBasicStatistics(numFiles, numRows, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    private static OptionalLong parse(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalLong.empty();
        }
        Long longValue = Longs.tryParse(parameterValue);
        if (longValue == null || longValue < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(longValue);
    }

    public static Map<String, String> updateStatisticsParameters(Map<String, String> parameters, HiveBasicStatistics statistics) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        parameters.forEach((key, value) -> {
            if (!STATS_PROPERTIES.contains(key)) {
                result.put(key, value);
            }
        });
        statistics.getFileCount().ifPresent(count -> result.put(NUM_FILES, Long.toString(count)));
        statistics.getRowCount().ifPresent(count -> result.put(NUM_ROWS, Long.toString(count)));
        statistics.getInMemoryDataSizeInBytes().ifPresent(size -> result.put(RAW_DATA_SIZE, Long.toString(size)));
        statistics.getOnDiskDataSizeInBytes().ifPresent(size -> result.put(TOTAL_SIZE, Long.toString(size)));
        return result.build();
    }
}

