/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.PrivilegeInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HivePrivilegeInfo {
    private final HivePrivilege hivePrivilege;
    private final boolean grantOption;
    private final PrestoPrincipal grantor;
    private final PrestoPrincipal grantee;

    @JsonCreator
    public HivePrivilegeInfo(@JsonProperty(value="hivePrivilege") HivePrivilege hivePrivilege, @JsonProperty(value="grantOption") boolean grantOption, @JsonProperty(value="grantor") PrestoPrincipal grantor, @JsonProperty(value="grantee") PrestoPrincipal grantee) {
        this.hivePrivilege = Objects.requireNonNull(hivePrivilege, "hivePrivilege is null");
        this.grantOption = grantOption;
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    @JsonProperty
    public PrestoPrincipal getGrantee() {
        return this.grantee;
    }

    @JsonProperty
    public HivePrivilege getHivePrivilege() {
        return this.hivePrivilege;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    @JsonProperty
    public PrestoPrincipal getGrantor() {
        return this.grantor;
    }

    public static HivePrivilege toHivePrivilege(Privilege privilege) {
        switch (privilege) {
            case SELECT: {
                return HivePrivilege.SELECT;
            }
            case INSERT: {
                return HivePrivilege.INSERT;
            }
            case DELETE: {
                return HivePrivilege.DELETE;
            }
            case UPDATE: {
                return HivePrivilege.UPDATE;
            }
        }
        throw new IllegalArgumentException("Unexpected privilege: " + privilege);
    }

    public boolean isContainedIn(HivePrivilegeInfo hivePrivilegeInfo) {
        return this.getHivePrivilege().equals((Object)hivePrivilegeInfo.getHivePrivilege()) && (this.isGrantOption() == hivePrivilegeInfo.isGrantOption() || !this.isGrantOption() && hivePrivilegeInfo.isGrantOption());
    }

    public Set<PrivilegeInfo> toPrivilegeInfo() {
        switch (this.hivePrivilege) {
            case SELECT: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.SELECT, this.isGrantOption()));
            }
            case INSERT: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.INSERT, this.isGrantOption()));
            }
            case DELETE: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.DELETE, this.isGrantOption()));
            }
            case UPDATE: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.UPDATE, this.isGrantOption()));
            }
            case OWNERSHIP: {
                return ImmutableSet.of();
            }
        }
        throw new IllegalArgumentException("Unsupported hivePrivilege: " + (Object)((Object)this.hivePrivilege));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hivePrivilege, this.grantOption, this.grantor, this.grantee});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrivilegeInfo hivePrivilegeInfo = (HivePrivilegeInfo)o;
        return Objects.equals((Object)this.hivePrivilege, (Object)hivePrivilegeInfo.hivePrivilege) && Objects.equals(this.grantOption, hivePrivilegeInfo.grantOption) && Objects.equals(this.grantor, hivePrivilegeInfo.grantor) && Objects.equals(this.grantee, hivePrivilegeInfo.grantee);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("privilege", (Object)this.hivePrivilege).add("grantOption", this.grantOption).add("grantor", this.grantor).add("grantee", this.grantee).toString();
    }

    public static enum HivePrivilege {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        OWNERSHIP;

    }
}

