/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreConfig;
import com.facebook.presto.hive.metastore.alluxio.AlluxioMetastoreModule;
import com.facebook.presto.hive.metastore.file.FileMetastoreModule;
import com.facebook.presto.hive.metastore.glue.GlueMetastoreModule;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final String connectorId;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HiveMetastoreModule(String connectorId, Optional<ExtendedHiveMetastore> metastore) {
        this.connectorId = connectorId;
        this.metastore = metastore;
    }

    @Override
    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(ExtendedHiveMetastore.class).toInstance(this.metastore.get());
        } else {
            this.bindMetastoreModule("thrift", new ThriftMetastoreModule(this.connectorId));
            this.bindMetastoreModule("file", new FileMetastoreModule(this.connectorId));
            this.bindMetastoreModule("glue", new GlueMetastoreModule(this.connectorId));
            this.bindMetastoreModule("alluxio", new AlluxioMetastoreModule());
        }
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(MetastoreConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), module));
    }
}

