/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.HiveType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.openjdk.jol.info.ClassLayout;

@Immutable
public class Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Column.class).instanceSize();
    private final String name;
    private final HiveType type;
    private final Optional<String> comment;

    @JsonCreator
    public Column(@JsonProperty(value="name") String name, @JsonProperty(value="type") HiveType type, @JsonProperty(value="comment") Optional<String> comment) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("type", this.type).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return Objects.equals(this.name, column.name) && Objects.equals(this.type, column.type) && Objects.equals(this.comment, column.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment);
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result += this.name.length() * 2;
        result += this.type.getEstimatedRetainedSizeInBytes();
        return result += this.comment.map(String::length).orElse(0).intValue();
    }
}

