/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionName;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.HiveTableName;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionFilter;
import com.facebook.presto.hive.metastore.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UserTableKey;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements ExtendedHiveMetastore {
    private static final String NO_IMPERSONATION_USER = "no-impersonation-caching-user";
    protected final ExtendedHiveMetastore delegate;
    private final LoadingCache<KeyAndContext<String>, Optional<Database>> databaseCache;
    private final LoadingCache<KeyAndContext<String>, List<String>> databaseNamesCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, Optional<Table>> tableCache;
    private final LoadingCache<KeyAndContext<String>, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, PartitionStatistics> tableStatisticsCache;
    private final LoadingCache<KeyAndContext<HivePartitionName>, PartitionStatistics> partitionStatisticsCache;
    private final LoadingCache<KeyAndContext<String>, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<KeyAndContext<HivePartitionName>, Optional<Partition>> partitionCache;
    private final LoadingCache<KeyAndContext<PartitionFilter>, List<String>> partitionFilterCache;
    private final LoadingCache<KeyAndContext<HiveTableName>, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<KeyAndContext<UserTableKey>, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<KeyAndContext<String>, Set<String>> rolesCache;
    private final LoadingCache<KeyAndContext<PrestoPrincipal>, Set<RoleGrant>> roleGrantsCache;
    private final boolean metastoreImpersonationEnabled;
    private final boolean partitionVersioningEnabled;
    private final double partitionCacheValidationPercentage;

    @Inject
    public CachingHiveMetastore(@ForCachingHiveMetastore ExtendedHiveMetastore delegate, @ForCachingHiveMetastore ExecutorService executor, MetastoreClientConfig metastoreClientConfig) {
        this(delegate, executor, metastoreClientConfig.isMetastoreImpersonationEnabled(), metastoreClientConfig.getMetastoreCacheTtl(), metastoreClientConfig.getMetastoreRefreshInterval(), metastoreClientConfig.getMetastoreCacheMaximumSize(), metastoreClientConfig.isPartitionVersioningEnabled(), metastoreClientConfig.getMetastoreCacheScope(), metastoreClientConfig.getPartitionCacheValidationPercentage());
    }

    public CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, boolean metastoreImpersonationEnabled, Duration cacheTtl, Duration refreshInterval, long maximumSize, boolean partitionVersioningEnabled, MetastoreCacheScope metastoreCacheScope, double partitionCacheValidationPercentage) {
        this(delegate, executor, metastoreImpersonationEnabled, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.toMillis() >= cacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(refreshInterval.toMillis()), maximumSize, partitionVersioningEnabled, metastoreCacheScope, partitionCacheValidationPercentage);
    }

    public static CachingHiveMetastore memoizeMetastore(ExtendedHiveMetastore delegate, boolean isMetastoreImpersonationEnabled, long maximumSize) {
        return new CachingHiveMetastore(delegate, (ExecutorService)MoreExecutors.newDirectExecutorService(), isMetastoreImpersonationEnabled, OptionalLong.empty(), OptionalLong.empty(), maximumSize, false, MetastoreCacheScope.ALL, 0.0);
    }

    private CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, boolean metastoreImpersonationEnabled, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, long maximumSize, boolean partitionVersioningEnabled, MetastoreCacheScope metastoreCacheScope, double partitionCacheValidationPercentage) {
        long cacheMaxSize;
        OptionalLong cacheRefreshMills;
        OptionalLong cacheExpiresAfterWriteMillis;
        long partitionCacheMaxSize;
        OptionalLong partitionCacheRefreshMills;
        OptionalLong partitionCacheExpiresAfterWriteMillis;
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.metastoreImpersonationEnabled = metastoreImpersonationEnabled;
        this.partitionVersioningEnabled = partitionVersioningEnabled;
        this.partitionCacheValidationPercentage = partitionCacheValidationPercentage;
        switch (metastoreCacheScope) {
            case PARTITION: {
                partitionCacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                partitionCacheRefreshMills = refreshMills;
                partitionCacheMaxSize = maximumSize;
                cacheExpiresAfterWriteMillis = OptionalLong.of(0L);
                cacheRefreshMills = OptionalLong.of(0L);
                cacheMaxSize = 0L;
                break;
            }
            case ALL: {
                partitionCacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                partitionCacheRefreshMills = refreshMills;
                partitionCacheMaxSize = maximumSize;
                cacheExpiresAfterWriteMillis = expiresAfterWriteMillis;
                cacheRefreshMills = refreshMills;
                cacheMaxSize = maximumSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown metastore-cache-scope: " + (Object)((Object)metastoreCacheScope));
            }
        }
        this.databaseNamesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadAllDatabases), executor));
        this.databaseCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadDatabase), executor));
        this.tableNamesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadAllTables), executor));
        this.tableStatisticsCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(new CacheLoader<KeyAndContext<HiveTableName>, PartitionStatistics>(){

            @Override
            public PartitionStatistics load(KeyAndContext<HiveTableName> key) {
                return CachingHiveMetastore.this.loadTableColumnStatistics(key);
            }
        }, executor));
        this.partitionStatisticsCache = CachingHiveMetastore.newCacheBuilder(partitionCacheExpiresAfterWriteMillis, partitionCacheRefreshMills, partitionCacheMaxSize).build(CacheLoader.asyncReloading(new CacheLoader<KeyAndContext<HivePartitionName>, PartitionStatistics>(){

            @Override
            public PartitionStatistics load(KeyAndContext<HivePartitionName> key) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(key);
            }

            @Override
            public Map<KeyAndContext<HivePartitionName>, PartitionStatistics> loadAll(Iterable<? extends KeyAndContext<HivePartitionName>> keys) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, executor));
        this.tableCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadTable), executor));
        this.viewNamesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadAllViews), executor));
        this.partitionNamesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadPartitionNames), executor));
        this.partitionFilterCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadPartitionNamesByFilter), executor));
        this.partitionCache = CachingHiveMetastore.newCacheBuilder(partitionCacheExpiresAfterWriteMillis, partitionCacheRefreshMills, partitionCacheMaxSize).build(CacheLoader.asyncReloading(new CacheLoader<KeyAndContext<HivePartitionName>, Optional<Partition>>(){

            @Override
            public Optional<Partition> load(KeyAndContext<HivePartitionName> partitionName) {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            @Override
            public Map<KeyAndContext<HivePartitionName>, Optional<Partition>> loadAll(Iterable<? extends KeyAndContext<HivePartitionName>> partitionNames) {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, executor));
        this.tablePrivilegesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadTablePrivileges), executor));
        this.rolesCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadAllRoles), executor));
        this.roleGrantsCache = CachingHiveMetastore.newCacheBuilder(cacheExpiresAfterWriteMillis, cacheRefreshMills, cacheMaxSize).build(CacheLoader.asyncReloading(CacheLoader.from(this::loadRoleGrants), executor));
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked(e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<Database> loadDatabase(KeyAndContext<String> databaseName) {
        return this.delegate.getDatabase(databaseName.getContext(), databaseName.getKey());
    }

    @Override
    public List<String> getAllDatabases(MetastoreContext metastoreContext) {
        return CachingHiveMetastore.get(this.databaseNamesCache, this.getCachingKey(metastoreContext, ""));
    }

    private List<String> loadAllDatabases(KeyAndContext<String> key) {
        return this.delegate.getAllDatabases(key.getContext());
    }

    @Override
    public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        return this.delegate.getSupportedColumnStatistics(metastoreContext, type);
    }

    private Optional<Table> loadTable(KeyAndContext<HiveTableName> hiveTableName) {
        return this.delegate.getTable(hiveTableName.getContext(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableStatisticsCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private PartitionStatistics loadTableColumnStatistics(KeyAndContext<HiveTableName> hiveTableName) {
        return this.delegate.getTableStatistics(hiveTableName.getContext(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        List partitions = partitionNames.stream().map(partitionName -> this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, partitionName))).collect(ImmutableList.toImmutableList());
        Map<KeyAndContext<HivePartitionName>, PartitionStatistics> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitions);
        return statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((KeyAndContext)entry.getKey()).getKey()).getPartitionName().get(), Map.Entry::getValue));
    }

    private PartitionStatistics loadPartitionColumnStatistics(KeyAndContext<HivePartitionName> partition) {
        String partitionName = partition.getKey().getPartitionName().get();
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(partition.getContext(), partition.getKey().getHiveTableName().getDatabaseName(), partition.getKey().getHiveTableName().getTableName(), ImmutableSet.of(partitionName));
        if (!partitionStatistics.containsKey(partitionName)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partition.getKey().getPartitionName());
        }
        return partitionStatistics.get(partitionName);
    }

    private Map<KeyAndContext<HivePartitionName>, PartitionStatistics> loadPartitionColumnStatistics(Iterable<? extends KeyAndContext<HivePartitionName>> keys) {
        SetMultimap tablePartitions = Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(nameKey -> this.getCachingKey(nameKey.getContext(), ((HivePartitionName)nameKey.getKey()).getHiveTableName()), nameKey -> nameKey));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(table -> {
            Set partitionNames = tablePartitions.get(table).stream().map(partitionName -> ((HivePartitionName)partitionName.getKey()).getPartitionName().get()).collect(ImmutableSet.toImmutableSet());
            Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(table.getContext(), ((HiveTableName)table.getKey()).getDatabaseName(), ((HiveTableName)table.getKey()).getTableName(), partitionNames);
            for (String partitionName2 : partitionNames) {
                if (!partitionStatistics.containsKey(partitionName2)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partitionName2);
                }
                result.put(this.getCachingKey(table.getContext(), HivePartitionName.hivePartitionName((HiveTableName)table.getKey(), partitionName2)), partitionStatistics.get(partitionName2));
            }
        });
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update2) {
        try {
            this.delegate.updateTableStatistics(metastoreContext, databaseName, tableName, update2);
        }
        finally {
            this.tableStatisticsCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(HiveTableName.hiveTableName(databaseName, tableName))).forEach(this.tableStatisticsCache::invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update2) {
        try {
            this.delegate.updatePartitionStatistics(metastoreContext, databaseName, tableName, partitionName, update2);
        }
        finally {
            this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilterKey -> ((HivePartitionName)partitionFilterKey.getKey()).equals(HivePartitionName.hivePartitionName(databaseName, tableName, partitionName))).forEach(this.partitionStatisticsCache::invalidate);
        }
    }

    @Override
    public Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<List<String>> loadAllTables(KeyAndContext<String> databaseNameKey) {
        return this.delegate.getAllTables(databaseNameKey.getContext(), databaseNameKey.getKey());
    }

    @Override
    public Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, this.getCachingKey(metastoreContext, databaseName));
    }

    private Optional<List<String>> loadAllViews(KeyAndContext<String> databaseNameKey) {
        return this.delegate.getAllViews(databaseNameKey.getContext(), databaseNameKey.getKey());
    }

    @Override
    public void createDatabase(MetastoreContext metastoreContext, Database database) {
        try {
            this.delegate.createDatabase(metastoreContext, database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(MetastoreContext metastoreContext, String databaseName) {
        try {
            this.delegate.dropDatabase(metastoreContext, databaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDatabase(MetastoreContext metastoreContext, String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(metastoreContext, databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.asMap().keySet().stream().filter(databaseKey -> ((String)databaseKey.getKey()).equals(databaseName)).forEach(this.databaseCache::invalidate);
        this.databaseNamesCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(MetastoreContext metastoreContext, Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(metastoreContext, table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(metastoreContext, databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(MetastoreContext metastoreContext, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.replaceTable(metastoreContext, databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(MetastoreContext metastoreContext, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(metastoreContext, databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(metastoreContext, databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(metastoreContext, databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(metastoreContext, databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.tableCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(this.tableCache::invalidate);
        this.tableNamesCache.asMap().keySet().stream().filter(tableNameKey -> ((String)tableNameKey.getKey()).equals(databaseName)).forEach(this.tableNamesCache::invalidate);
        this.viewNamesCache.asMap().keySet().stream().filter(viewNameKey -> ((String)viewNameKey.getKey()).equals(databaseName)).forEach(this.viewNamesCache::invalidate);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(userTableKey -> ((UserTableKey)userTableKey.getKey()).matches(databaseName, tableName)).forEach(this.tablePrivilegesCache::invalidate);
        this.tableStatisticsCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(this.tableStatisticsCache::invalidate);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    @Override
    public Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        KeyAndContext<HivePartitionName> key = this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, partitionValues));
        Optional<Partition> result = CachingHiveMetastore.get(this.partitionCache, key);
        if (this.isPartitionCacheValidationEnabled()) {
            this.validatePartitionCache(key, result);
        }
        return result;
    }

    @Override
    public Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.partitionNamesCache, this.getCachingKey(metastoreContext, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    private Optional<List<String>> loadPartitionNames(KeyAndContext<HiveTableName> hiveTableNameKey) {
        return this.delegate.getPartitionNames(hiveTableNameKey.getContext(), hiveTableNameKey.getKey().getDatabaseName(), hiveTableNameKey.getKey().getTableName());
    }

    @Override
    public List<String> getPartitionNamesByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        if (this.partitionVersioningEnabled) {
            List<PartitionNameWithVersion> partitionNamesWithVersion = this.getPartitionNamesWithVersionByFilter(metastoreContext, databaseName, tableName, partitionPredicates);
            List result = partitionNamesWithVersion.stream().map(PartitionNameWithVersion::getPartitionName).collect(ImmutableList.toImmutableList());
            this.invalidateStalePartitions(partitionNamesWithVersion, databaseName, tableName, metastoreContext);
            return result;
        }
        return CachingHiveMetastore.get(this.partitionFilterCache, this.getCachingKey(metastoreContext, PartitionFilter.partitionFilter(databaseName, tableName, partitionPredicates)));
    }

    @Override
    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        return this.delegate.getPartitionNamesWithVersionByFilter(metastoreContext, databaseName, tableName, partitionPredicates);
    }

    private void invalidateStalePartitions(List<PartitionNameWithVersion> partitionNamesWithVersion, String databaseName, String tableName, MetastoreContext metastoreContext) {
        for (PartitionNameWithVersion partitionNameWithVersion : partitionNamesWithVersion) {
            HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(databaseName, tableName, partitionNameWithVersion.getPartitionName());
            KeyAndContext<HivePartitionName> partitionNameKey = this.getCachingKey(metastoreContext, hivePartitionName);
            Optional partition = (Optional)this.partitionCache.getIfPresent(partitionNameKey);
            if (partition == null || !partition.isPresent()) {
                this.partitionCache.invalidate(partitionNameKey);
                this.partitionStatisticsCache.invalidate(partitionNameKey);
                continue;
            }
            Optional<Long> partitionVersion = ((Partition)partition.get()).getPartitionVersion();
            if (partitionVersion.isPresent() && partitionVersion.equals(partitionNameWithVersion.getPartitionVersion())) continue;
            this.partitionCache.invalidate(partitionNameKey);
            this.partitionStatisticsCache.invalidate(partitionNameKey);
        }
    }

    private boolean isPartitionCacheValidationEnabled() {
        return this.partitionCacheValidationPercentage > 0.0 && ThreadLocalRandom.current().nextDouble(100.0) < this.partitionCacheValidationPercentage;
    }

    private void validatePartitionCache(KeyAndContext<HivePartitionName> partitionName, Optional<Partition> partitionFromCache) {
        Optional<Partition> partitionFromMetastore = this.loadPartitionByName(partitionName);
        if (!partitionFromCache.equals(partitionFromMetastore)) {
            String errorMessage = String.format("Partition returned from cache is different from partition from Metastore.\nPartition name = %s.\nPartition from cache = %s\n Partition from Metastore = %s", partitionName, partitionFromCache, partitionFromMetastore);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_PARTITION_CACHE, errorMessage);
        }
    }

    private void validatePartitionCache(Map<KeyAndContext<HivePartitionName>, Optional<Partition>> actualResult) {
        Map<KeyAndContext<HivePartitionName>, Optional<Partition>> expectedResult = this.loadPartitionsByNames(actualResult.keySet());
        for (Map.Entry<KeyAndContext<HivePartitionName>, Optional<Partition>> entry : expectedResult.entrySet()) {
            Optional<Partition> partitionFromMetastore;
            HivePartitionName partitionName = entry.getKey().getKey();
            Optional<Partition> partitionFromCache = actualResult.get(entry.getKey());
            if (partitionFromCache.equals(partitionFromMetastore = entry.getValue())) continue;
            String errorMessage = String.format("Partition returned from cache is different from partition from Metastore.\nPartition name = %s.\nPartition from cache = %s\n Partition from Metastore = %s", partitionName, partitionFromCache, partitionFromMetastore);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_PARTITION_CACHE, errorMessage);
        }
    }

    private List<String> loadPartitionNamesByFilter(KeyAndContext<PartitionFilter> partitionFilterKey) {
        return this.delegate.getPartitionNamesByFilter(partitionFilterKey.getContext(), partitionFilterKey.getKey().getHiveTableName().getDatabaseName(), partitionFilterKey.getKey().getHiveTableName().getTableName(), partitionFilterKey.getKey().getPartitionPredicates());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
        Iterable names = Iterables.transform(partitionNames, name -> this.getCachingKey(metastoreContext, HivePartitionName.hivePartitionName(databaseName, tableName, name)));
        Map<KeyAndContext<HivePartitionName>, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        if (this.isPartitionCacheValidationEnabled()) {
            this.validatePartitionCache(all);
        }
        ImmutableMap.Builder<String, Optional<Partition>> partitionsByName = ImmutableMap.builder();
        for (Map.Entry<KeyAndContext<HivePartitionName>, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put(entry.getKey().getKey().getPartitionName().get(), entry.getValue());
        }
        return partitionsByName.build();
    }

    private Optional<Partition> loadPartitionByName(KeyAndContext<HivePartitionName> partitionName) {
        return this.delegate.getPartition(partitionName.getContext(), partitionName.getKey().getHiveTableName().getDatabaseName(), partitionName.getKey().getHiveTableName().getTableName(), partitionName.getKey().getPartitionValues());
    }

    private Map<KeyAndContext<HivePartitionName>, Optional<Partition>> loadPartitionsByNames(Iterable<? extends KeyAndContext<HivePartitionName>> partitionNamesKey) {
        Objects.requireNonNull(partitionNamesKey, "partitionNames is null");
        Preconditions.checkArgument(!Iterables.isEmpty(partitionNamesKey), "partitionNames is empty");
        KeyAndContext<HivePartitionName> firstPartitionKey = Iterables.get(partitionNamesKey, 0);
        HiveTableName hiveTableName = firstPartitionKey.getKey().getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (KeyAndContext<HivePartitionName> keyAndContext : partitionNamesKey) {
            Preconditions.checkArgument(keyAndContext.getKey().getHiveTableName().equals(hiveTableName), "Expected table name %s but got %s", (Object)hiveTableName, (Object)keyAndContext.getKey().getHiveTableName());
            Preconditions.checkArgument(keyAndContext.getContext().equals(firstPartitionKey.getContext()), "Expected context %s but got %s", (Object)firstPartitionKey.getContext(), (Object)keyAndContext.getContext());
            partitionsToFetch.add(keyAndContext.getKey().getPartitionName().get());
        }
        ImmutableMap.Builder<KeyAndContext<HivePartitionName>, Optional<Partition>> partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(firstPartitionKey.getContext(), databaseName, tableName, partitionsToFetch);
        for (Map.Entry<String, Optional<Partition>> entry : map.entrySet()) {
            partitions.put(this.getCachingKey(firstPartitionKey.getContext(), HivePartitionName.hivePartitionName(hiveTableName, entry.getKey())), entry.getValue());
        }
        return partitions.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.delegate.addPartitions(metastoreContext, databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(metastoreContext, databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            this.delegate.alterPartition(metastoreContext, databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        try {
            this.delegate.createRole(metastoreContext, role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(MetastoreContext metastoreContext, String role) {
        try {
            this.delegate.dropRole(metastoreContext, role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles(MetastoreContext metastoreContext) {
        return CachingHiveMetastore.get(this.rolesCache, this.getCachingKey(metastoreContext, ""));
    }

    private Set<String> loadAllRoles(KeyAndContext<String> rolesKey) {
        return this.delegate.listRoles(rolesKey.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        try {
            this.delegate.grantRoles(metastoreContext, roles, grantees, withAdminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        try {
            this.delegate.revokeRoles(metastoreContext, roles, grantees, adminOptionFor, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, this.getCachingKey(metastoreContext, principal));
    }

    private Set<RoleGrant> loadRoleGrants(KeyAndContext<PrestoPrincipal> principalKey) {
        return this.delegate.listRoleGrants(principalKey.getContext(), principalKey.getKey());
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.partitionNamesCache.asMap().keySet().stream().filter(hiveTableNameKey -> ((HiveTableName)hiveTableNameKey.getKey()).equals(hiveTableName)).forEach(this.partitionNamesCache::invalidate);
        this.partitionCache.asMap().keySet().stream().filter(partitionNameKey -> ((HivePartitionName)partitionNameKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(this.partitionCache::invalidate);
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilterKey -> ((PartitionFilter)partitionFilterKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(this.partitionFilterCache::invalidate);
        this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilterKey -> ((HivePartitionName)partitionFilterKey.getKey()).getHiveTableName().equals(hiveTableName)).forEach(this.partitionStatisticsCache::invalidate);
    }

    private void invalidateTablePrivilegesCache(PrestoPrincipal grantee, String databaseName, String tableName) {
        UserTableKey userTableKey = new UserTableKey(grantee, databaseName, tableName);
        this.tablePrivilegesCache.asMap().keySet().stream().filter(tablePrivilegesCacheKey -> ((UserTableKey)tablePrivilegesCacheKey.getKey()).equals(userTableKey)).forEach(this.tablePrivilegesCache::invalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.grantTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
        }
        finally {
            this.invalidateTablePrivilegesCache(grantee, databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.revokeTablePrivileges(metastoreContext, databaseName, tableName, grantee, privileges);
        }
        finally {
            this.invalidateTablePrivilegesCache(grantee, databaseName, tableName);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, this.getCachingKey(metastoreContext, new UserTableKey(principal, databaseName, tableName)));
    }

    public Set<HivePrivilegeInfo> loadTablePrivileges(KeyAndContext<UserTableKey> loadTablePrivilegesKey) {
        return this.delegate.listTablePrivileges(loadTablePrivilegesKey.getContext(), loadTablePrivilegesKey.getKey().getDatabase(), loadTablePrivilegesKey.getKey().getTable(), loadTablePrivilegesKey.getKey().getPrincipal());
    }

    private <T> KeyAndContext<T> getCachingKey(MetastoreContext context, T key) {
        MetastoreContext metastoreContext = this.metastoreImpersonationEnabled ? new MetastoreContext(context.getUsername(), context.getQueryId(), context.getClientInfo(), context.getSource(), true) : context;
        return new KeyAndContext<T>(metastoreContext, key);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder = cacheBuilder.maximumSize(maximumSize);
        return cacheBuilder;
    }

    private static class KeyAndContext<T> {
        private final MetastoreContext context;
        private final T key;

        public KeyAndContext(MetastoreContext context, T key) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.key = Objects.requireNonNull(key, "key is null");
        }

        public MetastoreContext getContext() {
            return this.context;
        }

        public T getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndContext other = (KeyAndContext)o;
            if (this.context.isImpersonationEnabled()) {
                return Objects.equals(this.context.getUsername(), other.context.getUsername()) && Objects.equals(this.key, other.key);
            }
            return Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            if (this.context.isImpersonationEnabled()) {
                return Objects.hash(this.context.getUsername(), this.key);
            }
            return Objects.hash(this.key);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("context", this.context).add("key", this.key).toString();
        }
    }

    public static enum MetastoreCacheScope {
        ALL,
        PARTITION;

    }
}

