/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.util.MergingPageIterator;
import com.facebook.presto.hive.util.SortBuffer;
import com.facebook.presto.hive.util.TempFileReader;
import com.facebook.presto.hive.util.TempFileWriter;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openjdk.jol.info.ClassLayout;

public class SortingFileWriter
implements HiveFileWriter {
    private static final Logger log = Logger.get(SortingFileWriter.class);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SortingFileWriter.class).instanceSize();
    private final FileSystem fileSystem;
    private final Path tempFilePrefix;
    private final int maxOpenTempFiles;
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final HiveFileWriter outputWriter;
    private final SortBuffer sortBuffer;
    private final TempFileSinkFactory tempFileSinkFactory;
    private final boolean sortedWriteToTempPathEnabled;
    private final Queue<TempFile> tempFiles = new PriorityQueue<TempFile>(Comparator.comparing(TempFile::getSize));

    public SortingFileWriter(FileSystem fileSystem, Path tempFilePrefix, HiveFileWriter outputWriter, DataSize maxMemory, int maxOpenTempFiles, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, PageSorter pageSorter, TempFileSinkFactory tempFileSinkFactory, boolean sortedWriteToTempPathEnabled) {
        Preconditions.checkArgument(maxOpenTempFiles >= 2, "maxOpenTempFiles must be at least two");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.tempFilePrefix = Objects.requireNonNull(tempFilePrefix, "tempFilePrefix is null");
        this.maxOpenTempFiles = maxOpenTempFiles;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortFields, "sortFields is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.outputWriter = Objects.requireNonNull(outputWriter, "outputWriter is null");
        this.sortBuffer = new SortBuffer(maxMemory, types, sortFields, sortOrders, pageSorter);
        this.tempFileSinkFactory = tempFileSinkFactory;
        this.sortedWriteToTempPathEnabled = sortedWriteToTempPathEnabled;
    }

    @Override
    public long getWrittenBytes() {
        return this.outputWriter.getWrittenBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.sortBuffer.getRetainedBytes();
    }

    @Override
    public void appendRows(Page page) {
        if (!this.sortBuffer.canAdd(page)) {
            this.flushToTempFile();
        }
        this.sortBuffer.add(page);
    }

    @Override
    public Optional<Page> commit() {
        if (!this.sortBuffer.isEmpty()) {
            if (this.tempFiles.isEmpty()) {
                this.sortBuffer.flushTo(this.outputWriter::appendRows);
                return this.outputWriter.commit();
            }
            this.flushToTempFile();
        }
        try {
            this.writeSorted();
            return this.outputWriter.commit();
        }
        catch (UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
    }

    @Override
    public void rollback() {
        if (!this.sortedWriteToTempPathEnabled) {
            for (TempFile file : this.tempFiles) {
                this.cleanupFile(file.getPath());
            }
        }
        this.outputWriter.rollback();
    }

    @Override
    public long getValidationCpuNanos() {
        return this.outputWriter.getValidationCpuNanos();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tempFilePrefix", this.tempFilePrefix).add("outputWriter", this.outputWriter).toString();
    }

    @Override
    public Optional<Runnable> getVerificationTask() {
        return this.outputWriter.getVerificationTask();
    }

    @Override
    public long getFileSizeInBytes() {
        return this.getWrittenBytes();
    }

    private void flushToTempFile() {
        this.writeTempFile(writer -> this.sortBuffer.flushTo(writer::writePage));
    }

    private void writeSorted() {
        this.combineFiles();
        this.mergeFiles(this.tempFiles, this.outputWriter::appendRows);
    }

    private void combineFiles() {
        while (this.tempFiles.size() > this.maxOpenTempFiles) {
            int count = Math.min(this.maxOpenTempFiles, this.tempFiles.size() - (this.maxOpenTempFiles - 1));
            List smallestFiles = IntStream.range(0, count).mapToObj(i -> this.tempFiles.poll()).collect(ImmutableList.toImmutableList());
            this.writeTempFile(writer -> this.mergeFiles(smallestFiles, writer::writePage));
        }
    }

    private void mergeFiles(Iterable<TempFile> files, Consumer<Page> consumer) {
        try (Closer closer = Closer.create();){
            Path file;
            ArrayList<Iterator<Page>> iterators = new ArrayList<Iterator<Page>>();
            for (TempFile tempFile : files) {
                file = tempFile.getPath();
                HdfsOrcDataSource dataSource = new HdfsOrcDataSource(new OrcDataSourceId(file.toString()), this.fileSystem.getFileStatus(file).getLen(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), false, this.fileSystem.open(file), new FileFormatDataSourceStats());
                closer.register(dataSource);
                iterators.add(new TempFileReader(this.types, (OrcDataSource)dataSource));
            }
            new MergingPageIterator(iterators, this.types, this.sortFields, this.sortOrders).forEachRemaining(consumer);
            if (!this.sortedWriteToTempPathEnabled) {
                for (TempFile tempFile : files) {
                    file = tempFile.getPath();
                    this.fileSystem.delete(file, false);
                    if (!this.fileSystem.exists(file)) continue;
                    throw new IOException("Failed to delete temporary file: " + file);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeTempFile(Consumer<TempFileWriter> consumer) {
        Path tempFile = this.getTempFileName();
        try (TempFileWriter writer = new TempFileWriter(this.types, this.tempFileSinkFactory.createSink(this.fileSystem, tempFile));){
            consumer.accept(writer);
            writer.close();
            this.tempFiles.add(new TempFile(tempFile, writer.getWrittenBytes()));
        }
        catch (IOException | UncheckedIOException e) {
            if (!this.sortedWriteToTempPathEnabled) {
                this.cleanupFile(tempFile);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to write temporary file: " + tempFile, (Throwable)e);
        }
    }

    private void cleanupFile(Path file) {
        try {
            this.fileSystem.delete(file, false);
            if (this.fileSystem.exists(file)) {
                throw new IOException("Delete failed");
            }
        }
        catch (IOException e) {
            log.warn(e, "Failed to delete temporary file: " + file);
        }
    }

    private Path getTempFileName() {
        return new Path(this.tempFilePrefix + "." + UUID.randomUUID().toString().replaceAll("-", "_"));
    }

    public static interface TempFileSinkFactory {
        public DataSink createSink(FileSystem var1, Path var2) throws IOException;
    }

    private static class TempFile {
        private final Path path;
        private final long size;

        public TempFile(Path path, long size) {
            Preconditions.checkArgument(size >= 0L, "size is negative");
            this.path = Objects.requireNonNull(path, "path is null");
            this.size = size;
        }

        public Path getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("path", this.path).add("size", this.size).toString();
        }
    }
}

