/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.orc.OrcWriterOptions;
import io.airlift.units.DataSize;

public class OrcFileWriterConfig {
    private DataSize stripeMinSize = OrcWriterOptions.DEFAULT_STRIPE_MIN_SIZE;
    private DataSize stripeMaxSize = OrcWriterOptions.DEFAULT_STRIPE_MAX_SIZE;
    private int stripeMaxRowCount = 10000000;
    private int rowGroupMaxRowCount = 10000;
    private DataSize dictionaryMaxMemory = OrcWriterOptions.DEFAULT_DICTIONARY_MAX_MEMORY;
    private DataSize stringStatisticsLimit = OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT;
    private DataSize maxCompressionBufferSize = OrcWriterOptions.DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;

    public OrcWriterOptions.Builder toOrcWriterOptionsBuilder() {
        return OrcWriterOptions.builder().withStripeMinSize(this.stripeMinSize).withStripeMaxSize(this.stripeMaxSize).withStripeMaxRowCount(this.stripeMaxRowCount).withRowGroupMaxRowCount(this.rowGroupMaxRowCount).withDictionaryMaxMemory(this.dictionaryMaxMemory).withMaxStringStatisticsLimit(this.stringStatisticsLimit).withMaxCompressionBufferSize(this.maxCompressionBufferSize);
    }

    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    @Config(value="hive.orc.writer.stripe-min-size")
    public OrcFileWriterConfig setStripeMinSize(DataSize stripeMinSize) {
        this.stripeMinSize = stripeMinSize;
        return this;
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    @Config(value="hive.orc.writer.stripe-max-size")
    public OrcFileWriterConfig setStripeMaxSize(DataSize stripeMaxSize) {
        this.stripeMaxSize = stripeMaxSize;
        return this;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    @Config(value="hive.orc.writer.stripe-max-rows")
    public OrcFileWriterConfig setStripeMaxRowCount(int stripeMaxRowCount) {
        this.stripeMaxRowCount = stripeMaxRowCount;
        return this;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    @Config(value="hive.orc.writer.row-group-max-rows")
    public OrcFileWriterConfig setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        return this;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    @Config(value="hive.orc.writer.dictionary-max-memory")
    public OrcFileWriterConfig setDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        return this;
    }

    public DataSize getStringStatisticsLimit() {
        return this.stringStatisticsLimit;
    }

    @Config(value="hive.orc.writer.string-statistics-limit")
    public OrcFileWriterConfig setStringStatisticsLimit(DataSize stringStatisticsLimit) {
        this.stringStatisticsLimit = stringStatisticsLimit;
        return this;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    @Config(value="hive.orc.writer.max-compression-buffer-size")
    public OrcFileWriterConfig setMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        return this;
    }
}

