/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.hive.ForZeroRowFileCreator;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.pagefile.PageFileWriterFactory;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.mapred.JobConf;

public class HiveZeroRowFileCreator
implements ZeroRowFileCreator {
    private static final Logger log = Logger.get(HiveZeroRowFileCreator.class);
    private final HdfsEnvironment hdfsEnvironment;
    private final DataSinkFactory dataSinkFactory;
    private final ListeningExecutorService executor;

    @Inject
    public HiveZeroRowFileCreator(HdfsEnvironment hdfsEnvironment, DataSinkFactory dataSinkFactory, @ForZeroRowFileCreator ListeningExecutorService zeroRowFileCreatorExecutor) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.dataSinkFactory = Objects.requireNonNull(dataSinkFactory, "dataSinkFactory is null");
        this.executor = Objects.requireNonNull(zeroRowFileCreatorExecutor, "zeroRowFileCreatorExecutor is null");
    }

    @Override
    public void createFiles(ConnectorSession session, HdfsContext hdfsContext, Path destinationDirectory, List<String> fileNames, StorageFormat format, HiveCompressionCodec compressionCodec, Properties schema) {
        if (fileNames.isEmpty()) {
            return;
        }
        byte[] fileContent = this.generateZeroRowFile(session, hdfsContext, schema, format.getSerDe(), format.getOutputFormat(), compressionCodec);
        ArrayList<Future> commitFutures = new ArrayList<Future>();
        for (String fileName : fileNames) {
            commitFutures.add(this.executor.submit(() -> this.createFile(hdfsContext, new Path(destinationDirectory, fileName), fileContent, session)));
        }
        ListenableFuture<Object> listenableFutureAggregate = Futures.whenAllSucceed(commitFutures).call(() -> null, MoreExecutors.directExecutor());
        try {
            MoreFutures.getFutureValue(listenableFutureAggregate, PrestoException.class);
        }
        catch (RuntimeException e) {
            listenableFutureAggregate.cancel(true);
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    private byte[] generateZeroRowFile(ConnectorSession session, HdfsContext hdfsContext, Properties properties, String serDe, String outputFormatName, HiveCompressionCodec compressionCodec) {
        JobConf conf;
        Path target;
        java.nio.file.Path tmpFilePath;
        block11: {
            String tmpDirectoryPath = System.getProperty("java.io.tmpdir");
            String tmpFileName = String.format("presto-hive-zero-row-file-creator-%s-%s", session.getQueryId(), UUID.randomUUID().toString());
            tmpFilePath = Paths.get(tmpDirectoryPath, tmpFileName);
            target = new Path(String.format("file://%s/%s", tmpDirectoryPath, tmpFileName));
            conf = ConfigurationUtils.configureCompression(this.hdfsEnvironment.getConfiguration(hdfsContext, target), outputFormatName.equals(HiveStorageFormat.JSON.getOutputFormat()) ? compressionCodec : HiveCompressionCodec.NONE);
            if (!outputFormatName.equals(HiveStorageFormat.PAGEFILE.getOutputFormat())) break block11;
            PageFileWriterFactory.createEmptyPageFile(this.dataSinkFactory, session, target.getFileSystem((Configuration)conf), target);
            byte[] byArray = Files.readAllBytes(tmpFilePath);
            try {
                Files.deleteIfExists(tmpFilePath);
            }
            catch (IOException e) {
                log.error(e, "Error deleting temporary file: %s", tmpFilePath);
            }
            return byArray;
        }
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName, session);
        recordWriter.close(false);
        byte[] byArray = Files.readAllBytes(tmpFilePath);
        try {
            Files.deleteIfExists(tmpFilePath);
        }
        catch (IOException e) {
            log.error(e, "Error deleting temporary file: %s", tmpFilePath);
        }
        return byArray;
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                try {
                    Files.deleteIfExists(tmpFilePath);
                }
                catch (IOException e2) {
                    log.error(e2, "Error deleting temporary file: %s", tmpFilePath);
                }
                throw throwable;
            }
        }
    }

    private void createFile(HdfsContext hdfsContext, Path path, byte[] content, ConnectorSession session) {
        try {
            ExtendedFileSystem fs = this.hdfsEnvironment.getFileSystem(hdfsContext, path);
            try (DataSink dataSink = this.dataSinkFactory.createDataSink(session, fs, path);){
                DataOutput dataOutput = DataOutput.createDataOutput(Slices.wrappedBuffer(content));
                dataSink.write(ImmutableList.of(dataOutput));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write zero-row file to Hive", (Throwable)e);
        }
    }
}

