/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveTypeTranslator
implements TypeTranslator {
    @Override
    public TypeInfo translate(Type type, Optional<HiveType> defaultHiveType) {
        if (BooleanType.BOOLEAN.equals(type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals(type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals(type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals(type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals(type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals(type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals(type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            if (varcharLength <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharLength);
            }
            if (varcharLength == Integer.MAX_VALUE) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals(type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals(type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (TimestampType.TIMESTAMP.equals(type)) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (MetastoreUtil.isArrayType(type)) {
            TypeInfo elementType = this.translate(type.getTypeParameters().get(0), defaultHiveType);
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (MetastoreUtil.isMapType(type)) {
            TypeInfo keyType = this.translate(type.getTypeParameters().get(0), defaultHiveType);
            TypeInfo valueType = this.translate(type.getTypeParameters().get(1), defaultHiveType);
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (MetastoreUtil.isRowType(type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                if (!namedTypeSignature.getName().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type));
                }
                fieldNames.add(namedTypeSignature.getName().get());
            }
            return TypeInfoFactory.getStructTypeInfo((List)((Object)fieldNames.build()), type.getTypeParameters().stream().map(t -> this.translate((Type)t, defaultHiveType)).collect(Collectors.toList()));
        }
        return defaultHiveType.orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("No default Hive type provided for unsupported Hive type: %s", type))).getTypeInfo();
    }

    public static boolean isSupportedHiveType(Type type) {
        if (BooleanType.BOOLEAN.equals(type)) {
            return true;
        }
        if (BigintType.BIGINT.equals(type)) {
            return true;
        }
        if (IntegerType.INTEGER.equals(type)) {
            return true;
        }
        if (SmallintType.SMALLINT.equals(type)) {
            return true;
        }
        if (TinyintType.TINYINT.equals(type)) {
            return true;
        }
        if (RealType.REAL.equals(type)) {
            return true;
        }
        if (DoubleType.DOUBLE.equals(type)) {
            return true;
        }
        if (type instanceof VarcharType) {
            return true;
        }
        if (type instanceof CharType) {
            return true;
        }
        if (VarbinaryType.VARBINARY.equals(type)) {
            return true;
        }
        if (DateType.DATE.equals(type)) {
            return true;
        }
        if (TimestampType.TIMESTAMP.equals(type)) {
            return true;
        }
        if (type instanceof DecimalType) {
            return true;
        }
        if (MetastoreUtil.isArrayType(type)) {
            return HiveTypeTranslator.isSupportedHiveType(type.getTypeParameters().get(0));
        }
        if (MetastoreUtil.isMapType(type)) {
            return HiveTypeTranslator.isSupportedHiveType(type.getTypeParameters().get(0)) && HiveTypeTranslator.isSupportedHiveType(type.getTypeParameters().get(1));
        }
        if (MetastoreUtil.isRowType(type)) {
            return type.getTypeParameters().stream().allMatch(HiveTypeTranslator::isSupportedHiveType);
        }
        return false;
    }
}

