/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.openjdk.jol.info.ClassLayout;

public final class HiveType {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveType.class).instanceSize();
    public static final HiveType HIVE_BOOLEAN = new HiveType((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    public static final HiveType HIVE_BYTE = new HiveType((TypeInfo)TypeInfoFactory.byteTypeInfo);
    public static final HiveType HIVE_SHORT = new HiveType((TypeInfo)TypeInfoFactory.shortTypeInfo);
    public static final HiveType HIVE_INT = new HiveType((TypeInfo)TypeInfoFactory.intTypeInfo);
    public static final HiveType HIVE_LONG = new HiveType((TypeInfo)TypeInfoFactory.longTypeInfo);
    public static final HiveType HIVE_FLOAT = new HiveType((TypeInfo)TypeInfoFactory.floatTypeInfo);
    public static final HiveType HIVE_DOUBLE = new HiveType((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    public static final HiveType HIVE_STRING = new HiveType((TypeInfo)TypeInfoFactory.stringTypeInfo);
    public static final HiveType HIVE_TIMESTAMP = new HiveType((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    public static final HiveType HIVE_DATE = new HiveType((TypeInfo)TypeInfoFactory.dateTypeInfo);
    public static final HiveType HIVE_BINARY = new HiveType((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    private final HiveTypeName hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = new HiveTypeName(typeInfo.getTypeName());
        this.typeInfo = typeInfo;
    }

    public HiveTypeName getHiveTypeName() {
        return this.hiveTypeName;
    }

    public ObjectInspector.Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public TypeSignature getTypeSignature() {
        return HiveType.getTypeSignature(this.typeInfo);
    }

    public Type getType(TypeManager typeManager) {
        return typeManager.getType(this.getTypeSignature());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.hiveTypeName.toString();
    }

    public boolean isSupportedType() {
        return HiveType.isSupportedType(this.getTypeInfo());
    }

    public static boolean isSupportedType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo) != null;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return HiveType.isSupportedType(mapTypeInfo.getMapKeyTypeInfo()) && HiveType.isSupportedType(mapTypeInfo.getMapValueTypeInfo());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return HiveType.isSupportedType(listTypeInfo.getListElementTypeInfo());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(HiveType::isSupportedType);
            }
        }
        return false;
    }

    @JsonCreator
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.toHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeName));
    }

    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return ImmutableList.copyOf(TypeInfoUtils.getTypeInfosFromTypeString((String)hiveTypes).stream().map(HiveType::toHiveType).collect(Collectors.toList()));
    }

    private static HiveType toHiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        return new HiveType(typeInfo);
    }

    public static HiveType toHiveType(TypeTranslator typeTranslator, Type type) {
        return HiveType.toHiveType(typeTranslator, type, Optional.empty());
    }

    public static HiveType toHiveType(TypeTranslator typeTranslator, Type type, Optional<HiveType> defaultHiveType) {
        Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(defaultHiveType, "defaultHiveType is null");
        return new HiveType(typeTranslator.translate(type, defaultHiveType));
    }

    private static TypeSignature getTypeSignature(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                Type primitiveType = HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo);
                if (primitiveType == null) break;
                return primitiveType.getTypeSignature();
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeSignature keyType = HiveType.getTypeSignature(mapTypeInfo.getMapKeyTypeInfo());
                TypeSignature valueType = HiveType.getTypeSignature(mapTypeInfo.getMapValueTypeInfo());
                return new TypeSignature("map", ImmutableList.of(TypeSignatureParameter.of(keyType), TypeSignatureParameter.of(valueType)));
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeSignature elementType = HiveType.getTypeSignature(listTypeInfo.getListElementTypeInfo());
                return new TypeSignature("array", ImmutableList.of(TypeSignatureParameter.of(elementType)));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList structFieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList structFieldNames = structTypeInfo.getAllStructFieldNames();
                if (structFieldTypeInfos.size() != structFieldNames.size()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid Hive struct type: %s", typeInfo));
                }
                ImmutableList.Builder typeSignatureBuilder = ImmutableList.builder();
                for (int i = 0; i < structFieldTypeInfos.size(); ++i) {
                    TypeSignature typeSignature = HiveType.getTypeSignature((TypeInfo)structFieldTypeInfos.get(i));
                    String rowFieldName = ((String)structFieldNames.get(i)).toLowerCase(Locale.US);
                    typeSignatureBuilder.add(TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(rowFieldName, false)), typeSignature)));
                }
                return new TypeSignature("row", (List<TypeSignatureParameter>)((Object)typeSignatureBuilder.build()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
    }

    public static Type getPrimitiveType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return TinyintType.TINYINT;
            }
            case SHORT: {
                return SmallintType.SMALLINT;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case VARCHAR: {
                return VarcharType.createVarcharType(((VarcharTypeInfo)typeInfo).getLength());
            }
            case CHAR: {
                return CharType.createCharType(((CharTypeInfo)typeInfo).getLength());
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                return DecimalType.createDecimalType(decimalTypeInfo.precision(), decimalTypeInfo.scale());
            }
        }
        return null;
    }

    public int getEstimatedRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.hiveTypeName.getEstimatedSizeInBytes();
    }

    public Optional<HiveType> findChildType(List<String> childPath) {
        TypeInfo typeInfo = this.getTypeInfo();
        for (String part : childPath) {
            Preconditions.checkArgument(typeInfo instanceof StructTypeInfo, "typeinfo is not struct type", (Object)typeInfo);
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            typeInfo = structTypeInfo.getStructFieldTypeInfo(part);
        }
        return Optional.of(HiveType.toHiveType(typeInfo));
    }
}

