/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionInformationSource;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class HiveEncryptionInformationProvider {
    private final List<EncryptionInformationSource> sources;

    @Inject
    public HiveEncryptionInformationProvider(Set<EncryptionInformationSource> sources) {
        this(ImmutableList.copyOf((Collection)Objects.requireNonNull(sources, "sources is null")));
    }

    @VisibleForTesting
    HiveEncryptionInformationProvider(List<EncryptionInformationSource> sources) {
        this.sources = ImmutableList.copyOf((Collection)Objects.requireNonNull(sources, "sources is null"));
    }

    public Optional<Map<String, EncryptionInformation>> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, Partition> partitions) {
        for (EncryptionInformationSource source : this.sources) {
            Optional<Map<String, EncryptionInformation>> result = source.getReadEncryptionInformation(session, table, requestedColumns, partitions);
            if (result == null || !result.isPresent()) continue;
            return result.map(ImmutableMap::copyOf);
        }
        return Optional.empty();
    }

    public Optional<EncryptionInformation> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns) {
        for (EncryptionInformationSource source : this.sources) {
            Optional<EncryptionInformation> result = source.getReadEncryptionInformation(session, table, requestedColumns);
            if (result == null || !result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<EncryptionInformation> getWriteEncryptionInformation(ConnectorSession session, Optional<TableEncryptionProperties> tableEncryptionProperties, String dbName, String tableName) {
        if (!tableEncryptionProperties.isPresent()) {
            return Optional.empty();
        }
        for (EncryptionInformationSource source : this.sources) {
            Optional<EncryptionInformation> result = source.getWriteEncryptionInformation(session, tableEncryptionProperties.get(), dbName, tableName);
            if (result == null || !result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

