/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class EncryptionInformation {
    private final Optional<DwrfEncryptionMetadata> dwrfEncryptionMetadata;

    @JsonCreator
    public EncryptionInformation(@JsonProperty Optional<DwrfEncryptionMetadata> dwrfEncryptionMetadata) {
        this.dwrfEncryptionMetadata = Objects.requireNonNull(dwrfEncryptionMetadata, "dwrfEncryptionMetadata is null");
    }

    @JsonProperty
    public Optional<DwrfEncryptionMetadata> getDwrfEncryptionMetadata() {
        return this.dwrfEncryptionMetadata;
    }

    public static EncryptionInformation fromEncryptionMetadata(EncryptionMetadata encryptionMetadata) {
        Objects.requireNonNull(encryptionMetadata, "encryptionMetadata is null");
        if (encryptionMetadata instanceof DwrfEncryptionMetadata) {
            return new EncryptionInformation(Optional.of((DwrfEncryptionMetadata)encryptionMetadata));
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, "Unknown encryptionMetadata type: " + encryptionMetadata.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.dwrfEncryptionMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        EncryptionInformation otherObj = (EncryptionInformation)obj;
        return Objects.equals(this.dwrfEncryptionMetadata, otherObj.dwrfEncryptionMetadata);
    }
}

