/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.AbstractVarcharType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.encoding.Base32;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class VarcharEnumType
extends AbstractVarcharType
implements EnumType<String> {
    private final VarcharEnumMap enumMap;

    public VarcharEnumType(VarcharEnumMap enumMap) {
        super(Integer.MAX_VALUE, new TypeSignature("VarcharEnum", TypeSignatureParameter.of(enumMap)));
        this.enumMap = enumMap;
    }

    @Override
    public Map<String, String> getEnumMap() {
        return this.enumMap.getEnumMap();
    }

    @Override
    public Optional<String> getEnumKeyForValue(String value) {
        return this.enumMap.getKeyForValue(value);
    }

    @Override
    public Type getValueType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public String getDisplayName() {
        return this.enumMap.getTypeName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTypeSignature().getBase(), this.enumMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarcharEnumType other = (VarcharEnumType)o;
        return Objects.equals(this.getTypeSignature().getBase(), other.getTypeSignature().getBase()) && Objects.equals(this.getEnumMap(), other.getEnumMap());
    }

    public static class VarcharEnumMap {
        private final String typeName;
        private final Map<String, String> enumMap;
        private final Map<String, String> flippedEnumMap;

        @JsonCreator
        public VarcharEnumMap(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="enumMap") Map<String, String> enumMap) {
            TypeUtils.validateEnumMap(Objects.requireNonNull(enumMap, "enumMap is null"));
            this.typeName = Objects.requireNonNull(typeName.toLowerCase(Locale.ENGLISH), "typeName is null");
            this.enumMap = TypeUtils.normalizeEnumMap(enumMap);
            this.flippedEnumMap = this.enumMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }

        @JsonProperty
        public String getTypeName() {
            return this.typeName;
        }

        @JsonProperty
        public Map<String, String> getEnumMap() {
            return this.enumMap;
        }

        public Optional<String> getKeyForValue(String value) {
            return Optional.ofNullable(this.flippedEnumMap.get(value));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarcharEnumMap other = (VarcharEnumMap)o;
            return Objects.equals(this.typeName, other.typeName) && Objects.equals(this.enumMap, other.enumMap);
        }

        public String toString() {
            Base32 base322 = new Base32();
            return String.format("%s{%s}", this.typeName, this.enumMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> String.format("\"%s\": \"%s\"", ((String)e.getKey()).replaceAll("\"", "\"\""), base322.encodeAsString(((String)e.getValue()).getBytes()))).collect(Collectors.joining(", ")));
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.enumMap);
        }
    }
}

