/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.GenericInternalException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class MethodHandleUtil {
    private static final MethodHandle GET_LONG = MethodHandleUtil.methodHandle(Type.class, "getLong", Block.class, Integer.TYPE);
    private static final MethodHandle GET_DOUBLE = MethodHandleUtil.methodHandle(Type.class, "getDouble", Block.class, Integer.TYPE);
    private static final MethodHandle GET_BOOLEAN = MethodHandleUtil.methodHandle(Type.class, "getBoolean", Block.class, Integer.TYPE);
    private static final MethodHandle GET_SLICE = MethodHandleUtil.methodHandle(Type.class, "getSlice", Block.class, Integer.TYPE);
    private static final MethodHandle GET_BLOCK = MethodHandleUtil.methodHandle(Type.class, "getObject", Block.class, Integer.TYPE).asType(MethodType.methodType(Block.class, Type.class, Block.class, Integer.TYPE));
    private static final MethodHandle WRITE_LONG = MethodHandleUtil.methodHandle(Type.class, "writeLong", BlockBuilder.class, Long.TYPE);
    private static final MethodHandle WRITE_DOUBLE = MethodHandleUtil.methodHandle(Type.class, "writeDouble", BlockBuilder.class, Double.TYPE);
    private static final MethodHandle WRITE_BOOLEAN = MethodHandleUtil.methodHandle(Type.class, "writeBoolean", BlockBuilder.class, Boolean.TYPE);
    private static final MethodHandle WRITE_SLICE = MethodHandleUtil.methodHandle(Type.class, "writeSlice", BlockBuilder.class, Slice.class);
    private static final MethodHandle WRITE_BLOCK = MethodHandleUtil.methodHandle(Type.class, "writeObject", BlockBuilder.class, Object.class).asType(MethodType.methodType(Void.TYPE, Type.class, BlockBuilder.class, Block.class));

    private MethodHandleUtil() {
    }

    public static MethodHandle compose(MethodHandle f, MethodHandle g2) {
        if (f.type().parameterType(0) != g2.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != g.return(). f: %s  g: %s", f.type(), g2.type()));
        }
        MethodHandle fUTS = MethodHandles.dropArguments(f, 1, g2.type().parameterList());
        return MethodHandles.foldArguments(fUTS, g2);
    }

    public static MethodHandle compose(MethodHandle f, MethodHandle g2, MethodHandle h2) {
        if (f.type().parameterCount() != 2) {
            throw new IllegalArgumentException(String.format("f.parameterCount != 2. f: %s", f.type()));
        }
        if (f.type().parameterType(0) != g2.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != g.return. f: %s  g: %s", f.type(), g2.type()));
        }
        if (f.type().parameterType(1) != h2.type().returnType()) {
            throw new IllegalArgumentException(String.format("f.parameter(0) != h.return. f: %s  h: %s", f.type(), h2.type()));
        }
        MethodType typeVTU = f.type().dropParameterTypes(0, 1).appendParameterTypes(h2.type().parameterList()).appendParameterTypes(new Class[]{f.type().parameterType(0)});
        MethodHandle fVTU = MethodHandles.permuteArguments(f, typeVTU, h2.type().parameterCount() + 1, 0);
        MethodHandle fhTU = MethodHandles.foldArguments(fVTU, h2);
        int[] reorder = new int[fhTU.type().parameterCount()];
        for (int i = 0; i < reorder.length - 1; ++i) {
            reorder[i] = i + 1 + g2.type().parameterCount();
        }
        reorder[reorder.length - 1] = 0;
        MethodType typeUST = f.type().dropParameterTypes(1, 2).appendParameterTypes(g2.type().parameterList()).appendParameterTypes(h2.type().parameterList());
        MethodHandle fhUST = MethodHandles.permuteArguments(fhTU, typeUST, reorder);
        return MethodHandles.foldArguments(fhUST, g2);
    }

    public static MethodHandle methodHandle(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflect(clazz.getMethod(name, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new GenericInternalException(e);
        }
    }

    public static MethodHandle nativeValueGetter(Type type) {
        MethodHandle methodHandle;
        Class<?> javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            methodHandle = GET_LONG;
        } else if (javaType == Double.TYPE) {
            methodHandle = GET_DOUBLE;
        } else if (javaType == Boolean.TYPE) {
            methodHandle = GET_BOOLEAN;
        } else if (javaType == Slice.class) {
            methodHandle = GET_SLICE;
        } else if (javaType == Block.class) {
            methodHandle = GET_BLOCK;
        } else {
            throw new IllegalArgumentException("Unknown java type " + javaType + " from type " + type);
        }
        return methodHandle.bindTo(type);
    }

    public static MethodHandle nativeValueWriter(Type type) {
        MethodHandle methodHandle;
        Class<?> javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            methodHandle = WRITE_LONG;
        } else if (javaType == Double.TYPE) {
            methodHandle = WRITE_DOUBLE;
        } else if (javaType == Boolean.TYPE) {
            methodHandle = WRITE_BOOLEAN;
        } else if (javaType == Slice.class) {
            methodHandle = WRITE_SLICE;
        } else if (javaType == Block.class) {
            methodHandle = WRITE_BLOCK;
        } else {
            throw new IllegalArgumentException("Unknown java type " + javaType + " from type " + type);
        }
        return methodHandle.bindTo(type);
    }
}

