/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.stats;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.Objects;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class GarbageCollectionNotificationInfo {
    private static final String MINOR_GC_NAME = "end of minor GC";
    private static final String MAJOR_GC_NAME = "end of major GC";
    private final String gcName;
    private final String gcAction;
    private final String gcCause;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;

    public GarbageCollectionNotificationInfo(CompositeData compositeData) {
        Objects.requireNonNull(compositeData, "compositeData is null");
        this.gcName = (String)compositeData.get("gcName");
        this.gcAction = (String)compositeData.get("gcAction");
        this.gcCause = (String)compositeData.get("gcCause");
        CompositeData gcInfo = (CompositeData)compositeData.get("gcInfo");
        this.startTime = (Long)gcInfo.get("startTime");
        this.endTime = (Long)gcInfo.get("endTime");
        this.usageBeforeGc = GarbageCollectionNotificationInfo.extractMemoryUsageMap(gcInfo, "memoryUsageBeforeGc");
        this.usageAfterGc = GarbageCollectionNotificationInfo.extractMemoryUsageMap(gcInfo, "memoryUsageAfterGc");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDurationMs() {
        return Math.max(0L, this.endTime - this.startTime);
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return this.usageBeforeGc;
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return this.usageAfterGc;
    }

    public DataSize getBeforeGcTotal() {
        return GarbageCollectionNotificationInfo.totalMemorySize(this.getMemoryUsageBeforeGc());
    }

    public DataSize getAfterGcTotal() {
        return GarbageCollectionNotificationInfo.totalMemorySize(this.getMemoryUsageAfterGc());
    }

    public boolean isMinorGc() {
        return this.gcAction.equalsIgnoreCase(MINOR_GC_NAME);
    }

    public boolean isMajorGc() {
        return this.gcAction.equalsIgnoreCase(MAJOR_GC_NAME);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("gcName", this.gcName).add("gcAction", this.gcAction).add("gcCause", this.gcCause).add("durationMs", this.getDurationMs()).add("beforeGcMb", this.getBeforeGcTotal()).add("afterGcMb", this.getAfterGcTotal()).toString();
    }

    private static DataSize totalMemorySize(Map<String, MemoryUsage> memUsages) {
        long bytes = 0L;
        for (MemoryUsage memoryUsage : memUsages.values()) {
            bytes += memoryUsage.getUsed();
        }
        return DataSize.succinctBytes(bytes);
    }

    private static Map<String, MemoryUsage> extractMemoryUsageMap(CompositeData compositeData, String attributeName) {
        ImmutableMap.Builder<String, MemoryUsage> map = ImmutableMap.builder();
        TabularData tabularData = (TabularData)compositeData.get(attributeName);
        for (CompositeData entry : tabularData.values()) {
            map.put((String)entry.get("key"), MemoryUsage.from((CompositeData)entry.get("value")));
        }
        return map.build();
    }
}

