/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.zorder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ZOrder {
    public static final int MAX_INPUT_DIMENSIONS = 10;
    private final List<Integer> encodingBits;
    private final int totalBitLength;
    private final int maxBitLength;

    public ZOrder(List<Integer> encodingBits) {
        Objects.requireNonNull(encodingBits, "Encoding bits list should not be null.");
        Preconditions.checkArgument(!encodingBits.isEmpty(), "Encoding bits list should not be empty.");
        this.encodingBits = encodingBits;
        this.totalBitLength = encodingBits.stream().mapToInt(Integer::intValue).sum();
        this.maxBitLength = encodingBits.stream().mapToInt(Integer::intValue).max().getAsInt();
    }

    public byte[] encodeToByteArray(List<Integer> input) {
        this.checkEncodeInputValidity(input);
        byte[] address = new byte[this.totalBitLength + 7 >> 3];
        int bitIndex = this.totalBitLength - 1;
        for (int bitsProcessed = 0; bitsProcessed < this.maxBitLength; ++bitsProcessed) {
            for (int index = 0; index < input.size(); ++index) {
                if (bitsProcessed >= this.encodingBits.get(index)) continue;
                int bitPosition = this.encodingBits.get(index) - bitsProcessed - 1;
                byte maskedBit = (byte)(input.get(index) >> bitPosition & 1);
                int n = bitIndex >> 3;
                address[n] = (byte)(address[n] | maskedBit << (bitIndex & 7));
                --bitIndex;
            }
        }
        return address;
    }

    public long encodeToLong(List<Integer> input) {
        this.checkEncodeInputValidity(input, 64);
        return this.zOrderByteAddressToLong(this.encodeToByteArray(input));
    }

    public int encodeToInteger(List<Integer> input) {
        this.checkEncodeInputValidity(input, 32);
        return (int)this.zOrderByteAddressToLong(this.encodeToByteArray(input));
    }

    public List<Integer> decode(byte[] address) {
        int[] output = new int[this.encodingBits.size()];
        int bitIndex = this.totalBitLength - 1;
        int bitsProcessed = 0;
        while (bitIndex >= 0) {
            for (int index = 0; index < output.length; ++index) {
                if (bitsProcessed >= this.encodingBits.get(index)) continue;
                byte maskedBit = (byte)(address[bitIndex >> 3] >> (bitIndex & 7) & 1);
                int bitPosition = this.encodingBits.get(index) - bitsProcessed - 1;
                int n = index;
                output[n] = output[n] | maskedBit << bitPosition;
                --bitIndex;
            }
            ++bitsProcessed;
        }
        return Arrays.stream(output).boxed().collect(ImmutableList.toImmutableList());
    }

    public List<Integer> decode(long address) {
        return this.decode(this.zOrderLongToByteAddress(address));
    }

    public List<Integer> decode(int address) {
        return this.decode((long)address);
    }

    public long zOrderByteAddressToLong(byte[] byteAddress) {
        long address = 0L;
        for (int byteIndex = 0; byteIndex < byteAddress.length; ++byteIndex) {
            address |= Byte.toUnsignedLong(byteAddress[byteIndex]) << (byteIndex << 3);
        }
        return address;
    }

    public byte[] zOrderLongToByteAddress(long address) {
        byte[] byteAddress = new byte[this.totalBitLength + 7 >> 3];
        for (int bitIndex = 0; bitIndex < this.totalBitLength; ++bitIndex) {
            int n = bitIndex >> 3;
            byteAddress[n] = (byte)((long)byteAddress[n] | (address >> bitIndex & 1L) << (bitIndex & 7));
        }
        return byteAddress;
    }

    private void checkEncodeInputValidity(List<Integer> input) {
        Objects.requireNonNull(input, "Input list should not be null.");
        Preconditions.checkArgument(!input.isEmpty(), "Input list size should be greater than zero.");
        Preconditions.checkArgument(input.size() <= 10, String.format("Current Z-Ordering implementation does not support more than %d input numbers.", 10));
        Preconditions.checkArgument(input.size() == this.encodingBits.size(), String.format("Input list size (%d) does not match encoding bits list size (%d).", input.size(), this.encodingBits.size()));
        input.forEach(value -> Preconditions.checkArgument(value >= 0, "Current Z-Ordering implementation does not support negative input numbers."));
    }

    private void checkEncodeInputValidity(List<Integer> input, int maximumBits) {
        this.checkEncodeInputValidity(input);
        Preconditions.checkArgument(this.totalBitLength <= maximumBits, String.format("The z-address type specified is not large enough to hold %d bits.", this.totalBitLength));
    }
}

