/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.util.ResumableTask;
import java.util.concurrent.Executor;

public final class ResumableTasks {
    private static final Logger log = Logger.get(ResumableTasks.class);

    private ResumableTasks() {
    }

    public static void submit(final Executor executor, final ResumableTask task) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ResumableTask.TaskStatus status = ResumableTasks.safeProcessTask(task);
                if (!status.isFinished()) {
                    status.getContinuationFuture().addListener(this, executor);
                }
            }
        });
    }

    private static ResumableTask.TaskStatus safeProcessTask(ResumableTask task) {
        try {
            return task.process();
        }
        catch (Throwable t) {
            log.warn(t, "ResumableTask completed exceptionally");
            return ResumableTask.TaskStatus.finished();
        }
    }
}

