/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.type.Decimals;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public final class DecimalUtils {
    private DecimalUtils() {
    }

    public static long getShortDecimalValue(HiveDecimalWritable writable, int columnScale) {
        byte[] bytes = writable.getInternalStorage();
        long value = DecimalUtils.getShortDecimalValue(bytes);
        value = Decimals.rescale(value, writable.getScale(), columnScale);
        return value;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        int i;
        long value = 0L;
        if ((bytes[0] & 0x80) != 0) {
            for (i = 0; i < 8 - bytes.length; ++i) {
                value |= 255L << 8 * (7 - i);
            }
        }
        for (i = 0; i < bytes.length; ++i) {
            value |= ((long)bytes[bytes.length - i - 1] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static Slice getLongDecimalValue(HiveDecimalWritable writable, int columnScale) {
        BigInteger value = new BigInteger(writable.getInternalStorage());
        value = Decimals.rescale(value, writable.getScale(), columnScale);
        return Decimals.encodeUnscaledValue(value);
    }
}

