/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = new DataSize(16.0, DataSize.Unit.MEGABYTE).toBytes();
    private static final int NULL_ENTRY_SIZE = 0;
    private final RcFileReader rcFileReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private long completedPositions;
    private boolean closed;

    public RcFilePageSource(RcFileReader rcFileReader, List<HiveColumnHandle> columns, TypeManager typeManager) {
        Objects.requireNonNull(rcFileReader, "rcReader is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.rcFileReader = rcFileReader;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder hiveTypesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add(name);
            typesBuilder.add(type);
            hiveTypesBuilder.add(column.getHiveType());
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (this.hiveColumnIndexes[columnIndex] < rcFileReader.getColumnCount()) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.rcFileReader.getBytesRead();
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.rcFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.pageId;
            int currentPageSize = this.rcFileReader.advance();
            if (currentPageSize < 0) {
                this.close();
                return null;
            }
            this.completedPositions += (long)currentPageSize;
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? new RunLengthEncodedBlock(this.constantBlocks[fieldId], currentPageSize) : this.createBlock(currentPageSize, fieldId);
            }
            return new Page(currentPageSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RcFileCorruptionException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", this.rcFileReader.getId()), (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", this.rcFileReader.getId()), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rcFileReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (Exception e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private Block createBlock(int currentPageSize, int fieldId) {
        int hiveColumnIndex = this.hiveColumnIndexes[fieldId];
        return new LazyBlock(currentPageSize, new RcFileBlockLoader(hiveColumnIndex));
    }

    private final class RcFileBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        public RcFileBlockLoader(int columnIndex) {
            this.expectedBatchId = RcFilePageSource.this.pageId;
            this.columnIndex = columnIndex;
        }

        @Override
        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState(RcFilePageSource.this.pageId == this.expectedBatchId);
            try {
                Block block = RcFilePageSource.this.rcFileReader.readBlock(this.columnIndex);
                lazyBlock.setBlock(block);
            }
            catch (RcFileCorruptionException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", RcFilePageSource.this.rcFileReader.getId()), (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", RcFilePageSource.this.rcFileReader.getId()), (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

