/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.pagefile.PageFileFooterReader;
import com.facebook.presto.hive.pagefile.PageFilePageReader;
import com.facebook.presto.hive.pagefile.PageFileWriterFactory;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public class PageFilePageSource
implements ConnectorPageSource {
    private final FSDataInputStream inputStream;
    private final Iterator<Page> pageReader;
    private final int[] hiveColumnIndexes;
    private boolean closed;
    private long completedPositions;
    private long completedBytes;
    private long readTimeNanos;
    private long memoryUsageBytes;

    public PageFilePageSource(FSDataInputStream inputStream, long start, long splitLength, long fileSize, BlockEncodingSerde blockEncodingSerde, List<HiveColumnHandle> columns) throws IOException {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        PageFileFooterReader pageFileFooterReader = new PageFileFooterReader(inputStream, fileSize);
        OffsetAndLength readStartAndLength = PageFilePageSource.getReadStartAndLength(start, splitLength, pageFileFooterReader.getFooterOffset(), pageFileFooterReader.getStripeOffsets());
        this.pageReader = new PageFilePageReader(readStartAndLength.getOffset(), readStartAndLength.getLength(), inputStream, PageFileWriterFactory.createPagesSerdeForPageFile(blockEncodingSerde, pageFileFooterReader.getCompression()));
        int size = Objects.requireNonNull(columns, "columns is null").size();
        this.hiveColumnIndexes = new int[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.closed || !this.pageReader.hasNext();
    }

    public Page getNextPage() {
        if (this.isFinished()) {
            return null;
        }
        long start = System.nanoTime();
        Page page = this.pageReader.next();
        Block[] blocks = new Block[this.hiveColumnIndexes.length];
        for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
            if (this.hiveColumnIndexes[fieldId] >= page.getChannelCount()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "schema evolution is not supported for PageFile format");
            }
            blocks[fieldId] = page.getBlock(this.hiveColumnIndexes[fieldId]);
        }
        this.readTimeNanos += System.nanoTime() - start;
        this.completedPositions += (long)page.getPositionCount();
        long pageSizeInBytes = page.getSizeInBytes();
        this.completedBytes += pageSizeInBytes;
        this.memoryUsageBytes = Math.max(this.memoryUsageBytes, pageSizeInBytes);
        return new Page(page.getPositionCount(), blocks);
    }

    public long getSystemMemoryUsage() {
        return this.memoryUsageBytes;
    }

    public void close() throws IOException {
        this.inputStream.close();
        this.closed = true;
    }

    private static OffsetAndLength getReadStartAndLength(long splitStart, long splitLength, long lastStripeEnd, List<Long> stripeOffsets) {
        Preconditions.checkArgument(stripeOffsets != null, "stripeOffsets is null, failed to read page file footer.");
        if (stripeOffsets.isEmpty()) {
            return new OffsetAndLength(0L, 0L);
        }
        long readStart = 0L;
        long readEnd = 0L;
        boolean stripeFound = false;
        for (int i = 0; i < stripeOffsets.size(); ++i) {
            if (PageFilePageSource.splitContainsStripe(splitStart, splitLength, stripeOffsets.get(i))) {
                if (!stripeFound) {
                    readStart = stripeOffsets.get(i);
                    stripeFound = true;
                }
                readEnd = i == stripeOffsets.size() - 1 ? lastStripeEnd : stripeOffsets.get(i + 1);
                continue;
            }
            if (stripeFound) break;
        }
        return new OffsetAndLength(readStart, readEnd - readStart);
    }

    private static boolean splitContainsStripe(long splitStart, long splitLength, long stripeOffset) {
        return splitStart <= stripeOffset && stripeOffset < splitStart + splitLength;
    }

    private static class OffsetAndLength {
        private final long offset;
        private final long length;

        OffsetAndLength(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        private long getOffset() {
            return this.offset;
        }

        private long getLength() {
            return this.length;
        }
    }
}

