/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;

public class PageFileFooterReader {
    private static final int ESTIMATED_FOOTER_SIZE = 1024;
    private final List<Long> stripeOffsets;
    private final long footerOffset;
    private final Optional<HiveCompressionCodec> compressionCodec;

    public PageFileFooterReader(FSDataInputStream inputStream, long fileSize) throws IOException {
        HiveCompressionCodec compression;
        Preconditions.checkArgument(fileSize >= 4L, "Malformed PageFile format, footer length is missing.");
        Objects.requireNonNull(inputStream, "inputStream is null");
        ImmutableList.Builder stripeOffsetsBuilder = ImmutableList.builder();
        byte[] buffer = new byte[Math.toIntExact(Math.min(fileSize, 1024L))];
        inputStream.readFully(fileSize - (long)buffer.length, buffer);
        int footerSize = Slices.wrappedBuffer(buffer, buffer.length - 4, 4).getInt(0);
        this.footerOffset = fileSize - (long)footerSize;
        if (this.footerOffset < 0L) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Malformed PageFile format, incorrect footer length.");
        }
        if (this.footerOffset > 0L) {
            if (footerSize > buffer.length) {
                buffer = new byte[footerSize];
                inputStream.readFully(this.footerOffset, buffer);
            }
            BasicSliceInput sliceInput = Slices.wrappedBuffer(buffer, buffer.length - footerSize, footerSize - 4).getInput();
            long remainingSize = ((FixedLengthSliceInput)sliceInput).length();
            int compressionStringSize = ((SliceInput)sliceInput).readInt();
            remainingSize -= 4L;
            String compressionName = ((SliceInput)sliceInput).readSlice(compressionStringSize).toStringUtf8();
            remainingSize -= (long)compressionStringSize;
            try {
                compression = HiveCompressionCodec.valueOf(compressionName);
            }
            catch (Exception e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("%s is invalid compression method in the footer of %s", compressionName, HiveStorageFormat.PAGEFILE.getInputFormat()));
            }
            int stripeCount = ((SliceInput)sliceInput).readInt();
            if ((remainingSize -= 4L) != (long)(8 * stripeCount)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Malformed PageFile format, incorrect stripe count.");
            }
            for (int i = 0; i < stripeCount; ++i) {
                stripeOffsetsBuilder.add((Object)((SliceInput)sliceInput).readLong());
            }
        } else {
            compression = null;
        }
        this.compressionCodec = Optional.ofNullable(compression);
        this.stripeOffsets = stripeOffsetsBuilder.build();
    }

    public List<Long> getStripeOffsets() {
        return this.stripeOffsets;
    }

    public long getFooterOffset() {
        return this.footerOffset;
    }

    public Optional<HiveCompressionCodec> getCompression() {
        return this.compressionCodec;
    }
}

