/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.CacheStatsMBean;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.TupleDomainFilterUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nullable;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class TupleDomainFilterCache {
    private final LoadingCache<DomainCacheKey, TupleDomainFilter> cache = CacheBuilder.newBuilder().recordStats().maximumSize(10000L).build(CacheLoader.from(cacheKey -> TupleDomainFilterUtils.toFilter((Domain)cacheKey.getDomain())));
    private final CacheStatsMBean cacheStats = new CacheStatsMBean(this.cache);

    public TupleDomainFilter getFilter(Domain domain) {
        return this.cache.getUnchecked(new DomainCacheKey(domain));
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getCache() {
        return this.cacheStats;
    }

    private static final class DomainCacheKey {
        private final Domain domain;

        private DomainCacheKey(Domain domain) {
            this.domain = domain;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainCacheKey cacheKey = (DomainCacheKey)o;
            return this.domain == cacheKey.domain;
        }

        public int hashCode() {
            return System.identityHashCode(this.domain);
        }
    }
}

