/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.security.SelectedRole;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.primitives.Shorts;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class ThriftMetastoreUtil {
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String ADMIN_ROLE_NAME = "admin";

    private ThriftMetastoreUtil() {
    }

    public static org.apache.hadoop.hive.metastore.api.Database toMetastoreApiDatabase(Database database) {
        org.apache.hadoop.hive.metastore.api.Database result = new org.apache.hadoop.hive.metastore.api.Database();
        result.setName(database.getDatabaseName());
        database.getLocation().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setLocationUri(arg_0));
        result.setOwnerName(database.getOwnerName());
        result.setOwnerType(ThriftMetastoreUtil.toMetastoreApiPrincipalType(database.getOwnerType()));
        database.getComment().ifPresent(arg_0 -> ((org.apache.hadoop.hive.metastore.api.Database)result).setDescription(arg_0));
        result.setParameters(database.getParameters());
        return result;
    }

    public static org.apache.hadoop.hive.metastore.api.Table toMetastoreApiTable(Table table, PrincipalPrivileges privileges) {
        org.apache.hadoop.hive.metastore.api.Table result = new org.apache.hadoop.hive.metastore.api.Table();
        result.setDbName(table.getDatabaseName());
        result.setTableName(table.getTableName());
        result.setOwner(table.getOwner());
        PrestoTableType tableType = table.getTableType();
        Preconditions.checkArgument(EnumSet.of(PrestoTableType.MANAGED_TABLE, PrestoTableType.EXTERNAL_TABLE, PrestoTableType.VIRTUAL_VIEW, PrestoTableType.MATERIALIZED_VIEW).contains((Object)tableType), "Invalid table type: %s", (Object)table.getTableType());
        if (PrestoTableType.MATERIALIZED_VIEW.equals((Object)tableType)) {
            tableType = PrestoTableType.MANAGED_TABLE;
        }
        result.setTableType(tableType.name());
        result.setParameters(table.getParameters());
        result.setPartitionKeys(table.getPartitionColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(Collectors.toList()));
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(table.getTableName(), table.getDataColumns(), table.getStorage()));
        result.setPrivileges(ThriftMetastoreUtil.toMetastoreApiPrincipalPrivilegeSet(privileges));
        result.setViewOriginalText((String)table.getViewOriginalText().orElse(null));
        result.setViewExpandedText((String)table.getViewExpandedText().orElse(null));
        return result;
    }

    private static PrincipalPrivilegeSet toMetastoreApiPrincipalPrivilegeSet(PrincipalPrivileges privileges) {
        ImmutableMap.Builder userPrivileges = ImmutableMap.builder();
        for (Map.Entry<String, Collection<HivePrivilegeInfo>> entry : privileges.getUserPrivileges().asMap().entrySet()) {
            userPrivileges.put(entry.getKey(), entry.getValue().stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toList()));
        }
        ImmutableMap.Builder rolePrivileges = ImmutableMap.builder();
        for (Map.Entry<String, Collection<HivePrivilegeInfo>> entry : privileges.getRolePrivileges().asMap().entrySet()) {
            rolePrivileges.put(entry.getKey(), entry.getValue().stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toList()));
        }
        return new PrincipalPrivilegeSet(userPrivileges.build(), ImmutableMap.of(), rolePrivileges.build());
    }

    public static PrivilegeGrantInfo toMetastoreApiPrivilegeGrantInfo(HivePrivilegeInfo privilegeInfo) {
        return new PrivilegeGrantInfo(privilegeInfo.getHivePrivilege().name().toLowerCase(Locale.ENGLISH), 0, privilegeInfo.getGrantor().getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(privilegeInfo.getGrantor().getType()), privilegeInfo.isGrantOption());
    }

    public static PrincipalType toMetastoreApiPrincipalType(com.facebook.presto.spi.security.PrincipalType principalType) {
        switch (principalType) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + principalType);
    }

    public static Stream<RoleGrant> listApplicableRoles(PrestoPrincipal principal, final Function<PrestoPrincipal, Set<RoleGrant>> listRoleGrants) {
        final ArrayDeque<PrestoPrincipal> queue = new ArrayDeque<PrestoPrincipal>();
        queue.add(principal);
        final ArrayDeque output = new ArrayDeque();
        final HashSet seenRoles = new HashSet();
        return Streams.stream(new AbstractIterator<RoleGrant>(){

            @Override
            protected RoleGrant computeNext() {
                if (!output.isEmpty()) {
                    return (RoleGrant)output.remove();
                }
                if (queue.isEmpty()) {
                    return (RoleGrant)this.endOfData();
                }
                while (!queue.isEmpty()) {
                    Set grants = (Set)listRoleGrants.apply(queue.remove());
                    if (grants.isEmpty()) continue;
                    for (RoleGrant grant : grants) {
                        if (!seenRoles.add(grant)) continue;
                        output.add(grant);
                        queue.add(new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.ROLE, grant.getRoleName()));
                    }
                }
                if (output.isEmpty()) {
                    return (RoleGrant)this.endOfData();
                }
                return (RoleGrant)output.remove();
            }
        });
    }

    public static boolean isRoleApplicable(SemiTransactionalHiveMetastore metastore, ConnectorIdentity identity, PrestoPrincipal principal, MetastoreContext metastoreContext, String role) {
        if (principal.getType() == com.facebook.presto.spi.security.PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        return ThriftMetastoreUtil.listApplicableRoles(metastore, identity, principal, metastoreContext).anyMatch(role::equals);
    }

    public static Stream<String> listApplicableRoles(SemiTransactionalHiveMetastore metastore, ConnectorIdentity identity, PrestoPrincipal principal, MetastoreContext metastoreContext) {
        return ThriftMetastoreUtil.listApplicableRoles(principal, p -> metastore.listRoleGrants(metastoreContext, (PrestoPrincipal)p)).map(RoleGrant::getRoleName);
    }

    public static Stream<PrestoPrincipal> listEnabledPrincipals(SemiTransactionalHiveMetastore metastore, ConnectorIdentity identity, MetastoreContext metastoreContext) {
        return Stream.concat(Stream.of(new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.USER, identity.getUser())), ThriftMetastoreUtil.listEnabledRoles(identity, p -> metastore.listRoleGrants(metastoreContext, (PrestoPrincipal)p)).map(role -> new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.ROLE, role)));
    }

    public static Stream<HivePrivilegeInfo> listEnabledTablePrivileges(SemiTransactionalHiveMetastore metastore, String databaseName, String tableName, ConnectorIdentity identity, MetastoreContext metastoreContext) {
        return ThriftMetastoreUtil.listTablePrivileges(identity, metastoreContext, metastore, databaseName, tableName, ThriftMetastoreUtil.listEnabledPrincipals(metastore, identity, metastoreContext));
    }

    public static Stream<HivePrivilegeInfo> listApplicableTablePrivileges(SemiTransactionalHiveMetastore metastore, ConnectorIdentity identity, MetastoreContext metastoreContext, String databaseName, String tableName, String user) {
        PrestoPrincipal userPrincipal = new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.USER, user);
        Stream<PrestoPrincipal> principals = Stream.concat(Stream.of(userPrincipal), ThriftMetastoreUtil.listApplicableRoles(metastore, identity, userPrincipal, metastoreContext).map(role -> new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.ROLE, role)));
        return ThriftMetastoreUtil.listTablePrivileges(identity, metastoreContext, metastore, databaseName, tableName, principals);
    }

    private static Stream<HivePrivilegeInfo> listTablePrivileges(ConnectorIdentity identity, MetastoreContext metastoreContext, SemiTransactionalHiveMetastore metastore, String databaseName, String tableName, Stream<PrestoPrincipal> principals) {
        return principals.flatMap(principal -> metastore.listTablePrivileges(metastoreContext, databaseName, tableName, (PrestoPrincipal)principal).stream());
    }

    public static boolean isRoleEnabled(ConnectorIdentity identity, Function<PrestoPrincipal, Set<RoleGrant>> listRoleGrants, String role) {
        if (role.equals(PUBLIC_ROLE_NAME)) {
            return true;
        }
        if (identity.getRole().isPresent() && ((SelectedRole)identity.getRole().get()).getType() == SelectedRole.Type.NONE) {
            return false;
        }
        PrestoPrincipal principal = !identity.getRole().isPresent() || ((SelectedRole)identity.getRole().get()).getType() == SelectedRole.Type.ALL ? new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.USER, identity.getUser()) : new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.ROLE, (String)((SelectedRole)identity.getRole().get()).getRole().get());
        if (principal.getType() == com.facebook.presto.spi.security.PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        if (role.equals(ADMIN_ROLE_NAME)) {
            return false;
        }
        return ThriftMetastoreUtil.listEnabledRoles(identity, listRoleGrants).anyMatch(role::equals);
    }

    public static Stream<String> listEnabledRoles(ConnectorIdentity identity, Function<PrestoPrincipal, Set<RoleGrant>> listRoleGrants) {
        Optional role = identity.getRole();
        if (role.isPresent() && ((SelectedRole)role.get()).getType() == SelectedRole.Type.NONE) {
            return Stream.of(PUBLIC_ROLE_NAME);
        }
        PrestoPrincipal principal = !role.isPresent() || ((SelectedRole)role.get()).getType() == SelectedRole.Type.ALL ? new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.USER, identity.getUser()) : new PrestoPrincipal(com.facebook.presto.spi.security.PrincipalType.ROLE, (String)((SelectedRole)role.get()).getRole().get());
        Stream<String> roles = Stream.of(PUBLIC_ROLE_NAME);
        if (principal.getType() == com.facebook.presto.spi.security.PrincipalType.ROLE) {
            roles = Stream.concat(roles, Stream.of(principal.getName()));
        }
        return Stream.concat(roles, ThriftMetastoreUtil.listApplicableRoles(principal, listRoleGrants).map(RoleGrant::getRoleName).filter(Predicate.isEqual(ADMIN_ROLE_NAME).negate()));
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(PartitionWithStatistics partitionWithStatistics) {
        org.apache.hadoop.hive.metastore.api.Partition partition = ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics.getPartition());
        partition.setParameters(MetastoreUtil.updateStatisticsParameters(partition.getParameters(), partitionWithStatistics.getStatistics().getBasicStatistics()));
        return partition;
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toMetastoreApiPartition(Partition partition) {
        org.apache.hadoop.hive.metastore.api.Partition result = new org.apache.hadoop.hive.metastore.api.Partition();
        result.setDbName(partition.getDatabaseName());
        result.setTableName(partition.getTableName());
        result.setValues(partition.getValues());
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(partition.getTableName(), partition.getColumns(), partition.getStorage()));
        result.setParameters(partition.getParameters());
        return result;
    }

    public static Database fromMetastoreApiDatabase(org.apache.hadoop.hive.metastore.api.Database database) {
        ImmutableMap<String, String> parameters;
        String ownerName = "PUBLIC";
        com.facebook.presto.spi.security.PrincipalType ownerType = com.facebook.presto.spi.security.PrincipalType.ROLE;
        if (database.getOwnerName() != null) {
            ownerName = database.getOwnerName();
            ownerType = ThriftMetastoreUtil.fromMetastoreApiPrincipalType(database.getOwnerType());
        }
        if ((parameters = database.getParameters()) == null) {
            parameters = ImmutableMap.of();
        }
        return Database.builder().setDatabaseName(database.getName()).setLocation(Optional.ofNullable(database.getLocationUri())).setOwnerName(ownerName).setOwnerType(ownerType).setComment(Optional.ofNullable(database.getDescription())).setParameters(parameters).build();
    }

    public static Table fromMetastoreApiTable(org.apache.hadoop.hive.metastore.api.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return ThriftMetastoreUtil.fromMetastoreApiTable(table, storageDescriptor.getCols());
    }

    public static Table fromMetastoreApiTable(org.apache.hadoop.hive.metastore.api.Table table, List<FieldSchema> schema) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        PrestoTableType tableType = PrestoTableType.optionalValueOf(table.getTableType()).orElse(PrestoTableType.OTHER);
        if (table.getParameters() != null && "true".equals(table.getParameters().get("presto_materialized_view"))) {
            Preconditions.checkState(TableType.MANAGED_TABLE.name().equals(table.getTableType()), "Materialized view %s has incorrect table type %s from Metastore.", (Object)table.getTableName(), (Object)table.getTableType());
            tableType = PrestoTableType.MATERIALIZED_VIEW;
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(Strings.nullToEmpty(table.getOwner())).setTableType(tableType).setDataColumns(schema.stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setPartitionColumns(table.getPartitionKeys().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setParameters(table.getParameters() == null ? ImmutableMap.of() : table.getParameters()).setViewOriginalText(Optional.ofNullable(Strings.emptyToNull(table.getViewOriginalText()))).setViewExpandedText(Optional.ofNullable(Strings.emptyToNull(table.getViewExpandedText())));
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, tableBuilder.getStorageBuilder(), table.getTableName());
        return tableBuilder.build();
    }

    public static boolean isAvroTableWithSchemaSet(org.apache.hadoop.hive.metastore.api.Table table) {
        if (table.getParameters() == null) {
            return false;
        }
        SerDeInfo serdeInfo = ThriftMetastoreUtil.getSerdeInfo(table);
        return serdeInfo.getSerializationLib() != null && (table.getParameters().get("avro.schema.url") != null || serdeInfo.getParameters() != null && serdeInfo.getParameters().get("avro.schema.url") != null) && serdeInfo.getSerializationLib().equals(HiveStorageFormat.AVRO.getSerDe());
    }

    public static boolean isCsvTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return HiveStorageFormat.CSV.getSerDe().equals(ThriftMetastoreUtil.getSerdeInfo(table).getSerializationLib());
    }

    private static SerDeInfo getSerdeInfo(org.apache.hadoop.hive.metastore.api.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table does not contain a storage descriptor: " + table);
        }
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        return serdeInfo;
    }

    public static Partition fromMetastoreApiPartition(org.apache.hadoop.hive.metastore.api.Partition partition, PartitionMutator partitionMutator) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + partition);
        }
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(partition.getDbName()).setTableName(partition.getTableName()).setValues(partition.getValues()).setColumns(storageDescriptor.getCols().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(Collectors.toList())).setParameters(partition.getParameters());
        partitionMutator.mutate(partitionBuilder, partition);
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, partitionBuilder.getStorageBuilder(), String.format("%s.%s", partition.getTableName(), partition.getValues()));
        return partitionBuilder.build();
    }

    public static HiveColumnStatistics fromMetastoreApiColumnStatistics(ColumnStatisticsObj columnStatistics, OptionalLong rowCount) {
        if (columnStatistics.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getStatsData().getLongStats();
            OptionalLong min2 = longStatsData.isSetLowValue() ? OptionalLong.of(longStatsData.getLowValue()) : OptionalLong.empty();
            OptionalLong max = longStatsData.isSetHighValue() ? OptionalLong.of(longStatsData.getHighValue()) : OptionalLong.empty();
            OptionalLong nullsCount = longStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(longStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = longStatsData.isSetNumDVs() ? OptionalLong.of(longStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createIntegerColumnStatistics(min2, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getStatsData().getDoubleStats();
            OptionalDouble min3 = doubleStatsData.isSetLowValue() ? OptionalDouble.of(doubleStatsData.getLowValue()) : OptionalDouble.empty();
            OptionalDouble max = doubleStatsData.isSetHighValue() ? OptionalDouble.of(doubleStatsData.getHighValue()) : OptionalDouble.empty();
            OptionalLong nullsCount = doubleStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(doubleStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = doubleStatsData.isSetNumDVs() ? OptionalLong.of(doubleStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDoubleColumnStatistics(min3, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getStatsData().getDecimalStats();
            Optional<BigDecimal> min4 = decimalStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty();
            Optional<BigDecimal> max = decimalStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = decimalStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(decimalStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = decimalStatsData.isSetNumDVs() ? OptionalLong.of(decimalStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDecimalColumnStatistics(min4, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getStatsData().getDateStats();
            Optional<LocalDate> min5 = dateStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty();
            Optional<LocalDate> max = dateStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = dateStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(dateStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = dateStatsData.isSetNumDVs() ? OptionalLong.of(dateStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDateColumnStatistics(min5, max, nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getStatsData().getBooleanStats();
            return HiveColumnStatistics.createBooleanColumnStatistics(booleanStatsData.isSetNumTrues() ? OptionalLong.of(booleanStatsData.getNumTrues()) : OptionalLong.empty(), booleanStatsData.isSetNumFalses() ? OptionalLong.of(booleanStatsData.getNumFalses()) : OptionalLong.empty(), booleanStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(booleanStatsData.getNumNulls()) : OptionalLong.empty());
        }
        if (columnStatistics.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStatsData().getStringStats();
            OptionalLong maxColumnLength = stringStatsData.isSetMaxColLen() ? OptionalLong.of(stringStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = stringStatsData.isSetAvgColLen() ? OptionalDouble.of(stringStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = stringStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(stringStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesCount = stringStatsData.isSetNumDVs() ? OptionalLong.of(stringStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createStringColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount, MetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
        }
        if (columnStatistics.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getStatsData().getBinaryStats();
            OptionalLong maxColumnLength = binaryStatsData.isSetMaxColLen() ? OptionalLong.of(binaryStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = binaryStatsData.isSetAvgColLen() ? OptionalDouble.of(binaryStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = binaryStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(binaryStatsData.getNumNulls()) : OptionalLong.empty();
            return HiveColumnStatistics.createBinaryColumnStatistics(maxColumnLength, ThriftMetastoreUtil.getTotalSizeInBytes(averageColumnLength, rowCount, nullsCount), nullsCount);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + columnStatistics);
    }

    public static Optional<LocalDate> fromMetastoreDate(Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }

    public static OptionalLong fromMetastoreNullsCount(long nullsCount) {
        if (nullsCount == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(nullsCount);
    }

    public static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()));
    }

    public static OptionalLong getTotalSizeInBytes(OptionalDouble averageColumnLength, OptionalLong rowCount, OptionalLong nullsCount) {
        if (averageColumnLength.isPresent() && rowCount.isPresent() && nullsCount.isPresent()) {
            long nonNullsCount = rowCount.getAsLong() - nullsCount.getAsLong();
            if (nonNullsCount < 0L) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(Math.round(averageColumnLength.getAsDouble() * (double)nonNullsCount));
        }
        return OptionalLong.empty();
    }

    public static Set<RoleGrant> fromRolePrincipalGrants(Collection<RolePrincipalGrant> grants) {
        return ImmutableSet.copyOf(grants.stream().map(ThriftMetastoreUtil::fromRolePrincipalGrant).collect(Collectors.toList()));
    }

    public static RoleGrant fromRolePrincipalGrant(RolePrincipalGrant grant) {
        return new RoleGrant(new PrestoPrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(grant.getPrincipalType()), grant.getPrincipalName()), grant.getRoleName(), grant.isGrantOption());
    }

    public static PrincipalType fromPrestoPrincipalType(com.facebook.presto.spi.security.PrincipalType principalType) {
        switch (principalType) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + principalType);
    }

    public static com.facebook.presto.spi.security.PrincipalType fromMetastoreApiPrincipalType(PrincipalType principalType) {
        Objects.requireNonNull(principalType, "principalType is null");
        switch (principalType) {
            case USER: {
                return com.facebook.presto.spi.security.PrincipalType.USER;
            }
            case ROLE: {
                return com.facebook.presto.spi.security.PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + principalType);
    }

    public static FieldSchema toMetastoreApiFieldSchema(Column column) {
        return new FieldSchema(column.getName(), column.getType().getHiveTypeName().toString(), (String)column.getComment().orElse(null));
    }

    public static Column fromMetastoreApiFieldSchema(FieldSchema fieldSchema) {
        return new Column(fieldSchema.getName(), HiveType.valueOf(fieldSchema.getType()), Optional.ofNullable(Strings.emptyToNull(fieldSchema.getComment())));
    }

    public static void fromMetastoreApiStorageDescriptor(StorageDescriptor storageDescriptor, Storage.Builder builder, String tablePartitionName) {
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        builder.setStorageFormat(StorageFormat.createNullable(serdeInfo.getSerializationLib(), storageDescriptor.getInputFormat(), storageDescriptor.getOutputFormat())).setLocation(Strings.nullToEmpty(storageDescriptor.getLocation())).setBucketProperty(HiveBucketProperty.fromStorageDescriptor(storageDescriptor, tablePartitionName)).setSkewed(storageDescriptor.isSetSkewedInfo() && storageDescriptor.getSkewedInfo().isSetSkewedColNames() && !storageDescriptor.getSkewedInfo().getSkewedColNames().isEmpty()).setSerdeParameters(serdeInfo.getParameters() == null ? ImmutableMap.of() : serdeInfo.getParameters()).setParameters(storageDescriptor.getParameters() == null ? ImmutableMap.of() : storageDescriptor.getParameters());
    }

    private static StorageDescriptor makeStorageDescriptor(String tableName, List<Column> columns, Storage storage) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(storage.getStorageFormat().getSerDeNullable());
        serdeInfo.setParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(Strings.emptyToNull(storage.getLocation()));
        sd.setCols(columns.stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(Collectors.toList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters(storage.getParameters());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumBuckets(bucketProperty.get().getBucketCount());
            sd.setBucketCols(bucketProperty.get().getBucketedBy());
            if (!bucketProperty.get().getSortedBy().isEmpty()) {
                sd.setSortCols(bucketProperty.get().getSortedBy().stream().map(column -> new Order(column.getColumnName(), column.getOrder().getHiveOrder())).collect(Collectors.toList()));
            }
        }
        return sd;
    }

    public static Set<HivePrivilegeInfo> parsePrivilege(PrivilegeGrantInfo userGrant, Optional<PrestoPrincipal> grantee) {
        boolean withGrantOption = userGrant.isGrantOption();
        String name = userGrant.getPrivilege().toUpperCase(Locale.ENGLISH);
        PrestoPrincipal grantor = new PrestoPrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(userGrant.getGrantorType()), userGrant.getGrantor());
        switch (name) {
            case "ALL": {
                return Arrays.stream(HivePrivilegeInfo.HivePrivilege.values()).map(hivePrivilege -> new HivePrivilegeInfo((HivePrivilegeInfo.HivePrivilege)((Object)hivePrivilege), withGrantOption, grantor, grantee.orElse(grantor))).collect(ImmutableSet.toImmutableSet());
            }
            case "SELECT": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, withGrantOption, grantor, grantee.orElse(grantor)));
            }
            case "INSERT": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, withGrantOption, grantor, grantee.orElse(grantor)));
            }
            case "UPDATE": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, withGrantOption, grantor, grantee.orElse(grantor)));
            }
            case "DELETE": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, withGrantOption, grantor, grantee.orElse(grantor)));
            }
            case "OWNERSHIP": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, withGrantOption, grantor, grantee.orElse(grantor)));
            }
        }
        throw new IllegalArgumentException("Unsupported privilege name: " + name);
    }

    public static ColumnStatisticsObj createMetastoreColumnStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        TypeInfo typeInfo = columnType.getTypeInfo();
        Preconditions.checkArgument(typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE, "unsupported type: %s", (Object)columnType);
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case BOOLEAN: {
                return ThriftMetastoreUtil.createBooleanStatistics(columnName, columnType, statistics);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return ThriftMetastoreUtil.createLongStatistics(columnName, columnType, statistics);
            }
            case FLOAT: 
            case DOUBLE: {
                return ThriftMetastoreUtil.createDoubleStatistics(columnName, columnType, statistics);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return ThriftMetastoreUtil.createStringStatistics(columnName, columnType, statistics, rowCount);
            }
            case DATE: {
                return ThriftMetastoreUtil.createDateStatistics(columnName, columnType, statistics);
            }
            case TIMESTAMP: {
                return ThriftMetastoreUtil.createLongStatistics(columnName, columnType, statistics);
            }
            case BINARY: {
                return ThriftMetastoreUtil.createBinaryStatistics(columnName, columnType, statistics, rowCount);
            }
            case DECIMAL: {
                return ThriftMetastoreUtil.createDecimalStatistics(columnName, columnType, statistics);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported type: %s", columnType));
    }

    private static ColumnStatisticsObj createBooleanStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        BooleanColumnStatsData data = new BooleanColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumNulls(arg_0));
        statistics.getBooleanStatistics().ifPresent(booleanStatistics -> {
            booleanStatistics.getFalseCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumFalses(arg_0));
            booleanStatistics.getTrueCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumTrues(arg_0));
        });
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.booleanStats((BooleanColumnStatsData)data));
    }

    private static ColumnStatisticsObj createLongStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        LongColumnStatsData data = new LongColumnStatsData();
        statistics.getIntegerStatistics().ifPresent(integerStatistics -> {
            integerStatistics.getMin().ifPresent(arg_0 -> ((LongColumnStatsData)data).setLowValue(arg_0));
            integerStatistics.getMax().ifPresent(arg_0 -> ((LongColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.longStats((LongColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDoubleStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DoubleColumnStatsData data = new DoubleColumnStatsData();
        statistics.getDoubleStatistics().ifPresent(doubleStatistics -> {
            doubleStatistics.getMin().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setLowValue(arg_0));
            doubleStatistics.getMax().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.doubleStats((DoubleColumnStatsData)data));
    }

    private static ColumnStatisticsObj createStringStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        StringColumnStatsData data = new StringColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumDVs(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.stringStats((StringColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDateStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DateColumnStatsData data = new DateColumnStatsData();
        statistics.getDateStatistics().ifPresent(dateStatistics -> {
            dateStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDate(value)));
            dateStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDate(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.dateStats((DateColumnStatsData)data));
    }

    private static ColumnStatisticsObj createBinaryStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics, OptionalLong rowCount) {
        BinaryColumnStatsData data = new BinaryColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BinaryColumnStatsData)data).setNumNulls(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.binaryStats((BinaryColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDecimalStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DecimalColumnStatsData data = new DecimalColumnStatsData();
        statistics.getDecimalStatistics().ifPresent(decimalStatistics -> {
            decimalStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
            decimalStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumNulls(arg_0));
        ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.decimalStats((DecimalColumnStatsData)data));
    }

    public static Date toMetastoreDate(LocalDate date) {
        return new Date(date.toEpochDay());
    }

    public static Decimal toMetastoreDecimal(BigDecimal decimal) {
        return new Decimal(Shorts.checkedCast(decimal.scale()), ByteBuffer.wrap(decimal.unscaledValue().toByteArray()));
    }

    private static OptionalLong toMetastoreDistinctValuesCount(OptionalLong distinctValuesCount, OptionalLong nullsCount) {
        if (distinctValuesCount.isPresent() && nullsCount.isPresent()) {
            return OptionalLong.of(distinctValuesCount.getAsLong() + (long)(nullsCount.getAsLong() > 0L ? 1 : 0));
        }
        return OptionalLong.empty();
    }

    private static OptionalDouble getAverageColumnLength(OptionalLong totalSizeInBytes, OptionalLong rowCount, OptionalLong nullsCount) {
        if (totalSizeInBytes.isPresent() && rowCount.isPresent() && nullsCount.isPresent()) {
            long nonNullsCount = rowCount.getAsLong() - nullsCount.getAsLong();
            if (nonNullsCount <= 0L) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of((double)totalSizeInBytes.getAsLong() / (double)nonNullsCount);
        }
        return OptionalDouble.empty();
    }
}

