/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;

public class StaticMetastoreConfig {
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private List<URI> metastoreUris;
    private String metastoreUsername;
    private boolean metastoreLoadBalancingEnabled;

    @NotNull
    public List<URI> getMetastoreUris() {
        return this.metastoreUris;
    }

    @Config(value="hive.metastore.uri")
    @ConfigDescription(value="Hive metastore URIs (comma separated)")
    public StaticMetastoreConfig setMetastoreUris(String uris) {
        if (uris == null) {
            this.metastoreUris = null;
            return this;
        }
        this.metastoreUris = ImmutableList.copyOf(Iterables.transform(SPLITTER.split(uris), URI::create));
        return this;
    }

    public String getMetastoreUsername() {
        return this.metastoreUsername;
    }

    @Config(value="hive.metastore.username")
    @ConfigDescription(value="Optional username for accessing the Hive metastore")
    public StaticMetastoreConfig setMetastoreUsername(String metastoreUsername) {
        this.metastoreUsername = metastoreUsername;
        return this;
    }

    public boolean isMetastoreLoadBalancingEnabled() {
        return this.metastoreLoadBalancingEnabled;
    }

    @Config(value="hive.metastore.load-balancing-enabled")
    @ConfigDescription(value="Enable load balancing between multiple Metastore instances")
    public StaticMetastoreConfig setMetastoreLoadBalancingEnabled(boolean enabled) {
        this.metastoreLoadBalancingEnabled = enabled;
        return this;
    }
}

