/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DoubleStatistics {
    private final OptionalDouble min;
    private final OptionalDouble max;

    @JsonCreator
    public DoubleStatistics(@JsonProperty(value="min") OptionalDouble min2, @JsonProperty(value="max") OptionalDouble max) {
        this.min = Objects.requireNonNull(min2, "min is null");
        this.max = Objects.requireNonNull(max, "max is null");
    }

    @JsonProperty
    public OptionalDouble getMin() {
        return this.min;
    }

    @JsonProperty
    public OptionalDouble getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleStatistics that = (DoubleStatistics)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("min", this.min).add("max", this.max).toString();
    }
}

