/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.authentication;

import com.facebook.airlift.log.Logger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.security.SecurityUtil;

public class KerberosAuthentication {
    private static final Logger log = Logger.get(KerberosAuthentication.class);
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private final KerberosPrincipal principal;
    private final Configuration configuration;

    public KerberosAuthentication(String principal, String keytabLocation) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(keytabLocation, "keytabLocation is null");
        Path keytabPath = Paths.get(keytabLocation, new String[0]);
        Preconditions.checkArgument(Files.exists(keytabPath, new LinkOption[0]), "keytab does not exist: " + keytabLocation);
        Preconditions.checkArgument(Files.isReadable(keytabPath), "keytab is not readable: " + keytabLocation);
        this.principal = KerberosAuthentication.createKerberosPrincipal(principal);
        this.configuration = KerberosAuthentication.createConfiguration(this.principal.getName(), keytabLocation);
    }

    public Subject getSubject() {
        Subject subject = new Subject(false, ImmutableSet.of(this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    private static KerberosPrincipal createKerberosPrincipal(String principal) {
        try {
            return new KerberosPrincipal(SecurityUtil.getServerPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Configuration createConfiguration(String principal, String keytabLocation) {
        ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder().put("useKeyTab", "true").put("storeKey", "true").put("doNotPrompt", "true").put("isInitiator", "true").put("principal", principal).put("keyTab", keytabLocation);
        if (log.isDebugEnabled()) {
            optionsBuilder.put("debug", "true");
        }
        final ImmutableMap<String, String> options = optionsBuilder.build();
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosAuthentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
    }
}

