/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class TableEncryptionProperties {
    private final Optional<String> encryptTable;
    private final Optional<ColumnEncryptionInformation> columnEncryptionInformation;

    protected TableEncryptionProperties(Optional<String> encryptTable, Optional<ColumnEncryptionInformation> columnEncryptionInformation) {
        this.encryptTable = Objects.requireNonNull(encryptTable, "encryptTable is null");
        this.columnEncryptionInformation = Objects.requireNonNull(columnEncryptionInformation, "columnEncryptionInformation is null");
        if (encryptTable.isPresent() && columnEncryptionInformation.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, "Exactly one of table or column settings can be present. Both are present");
        }
        if (!encryptTable.isPresent() && !columnEncryptionInformation.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, "Exactly one of table or column settings can be present. None are present");
        }
    }

    public Optional<String> getEncryptTable() {
        return this.encryptTable;
    }

    public Optional<ColumnEncryptionInformation> getColumnEncryptionInformation() {
        return this.columnEncryptionInformation;
    }

    protected Map<String, String> getFormatSpecificHiveProperties() {
        return ImmutableMap.of();
    }

    public Map<String, String> toHiveProperties() {
        ImmutableMap.Builder<String, String> tableProperties = ImmutableMap.builder();
        tableProperties.putAll(this.getFormatSpecificHiveProperties());
        this.encryptTable.ifPresent(reference -> tableProperties.put("encrypt.table", (String)reference));
        this.columnEncryptionInformation.ifPresent(columnInformation -> tableProperties.put("encrypt.columns", columnInformation.toHiveProperty()));
        return tableProperties.build();
    }

    protected Map<String, Object> getFormatSpecificTableProperties() {
        return ImmutableMap.of();
    }

    public Map<String, Object> toTableProperties() {
        ImmutableMap.Builder<String, Object> tableProperties = ImmutableMap.builder();
        tableProperties.putAll(this.getFormatSpecificTableProperties());
        this.encryptTable.ifPresent(reference -> tableProperties.put("encrypt_table", reference));
        this.columnEncryptionInformation.ifPresent(columnInformation -> tableProperties.put("encrypt_columns", columnInformation));
        return tableProperties.build();
    }

    public static boolean isTableEncrypted(Map<String, String> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return tableProperties.containsKey("encrypt.table") || tableProperties.containsKey("encrypt.columns");
    }
}

