/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class PartitionUpdate {
    private final String name;
    private final UpdateMode updateMode;
    private final Path writePath;
    private final Path targetPath;
    private final List<FileWriteInfo> fileWriteInfos;
    private final long rowCount;
    private final long inMemoryDataSizeInBytes;
    private final long onDiskDataSizeInBytes;
    private final boolean containsNumberedFileNames;

    @JsonCreator
    public PartitionUpdate(@JsonProperty(value="name") String name, @JsonProperty(value="updateMode") UpdateMode updateMode, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="fileWriteInfos") List<FileWriteInfo> fileWriteInfos, @JsonProperty(value="rowCount") long rowCount, @JsonProperty(value="inMemoryDataSizeInBytes") long inMemoryDataSizeInBytes, @JsonProperty(value="onDiskDataSizeInBytes") long onDiskDataSizeInBytes, @JsonProperty(value="containsNumberedFileNames") boolean containsNumberedFileNames) {
        this(name, updateMode, new Path(Objects.requireNonNull(writePath, "writePath is null")), new Path(Objects.requireNonNull(targetPath, "targetPath is null")), fileWriteInfos, rowCount, inMemoryDataSizeInBytes, onDiskDataSizeInBytes, containsNumberedFileNames);
    }

    public PartitionUpdate(String name, UpdateMode updateMode, Path writePath, Path targetPath, List<FileWriteInfo> fileWriteInfos, long rowCount, long inMemoryDataSizeInBytes, long onDiskDataSizeInBytes, boolean containsNumberedFileNames) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.fileWriteInfos = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileWriteInfos, "fileWriteInfos is null"));
        Preconditions.checkArgument(rowCount >= 0L, "rowCount is negative: %d", rowCount);
        this.rowCount = rowCount;
        Preconditions.checkArgument(inMemoryDataSizeInBytes >= 0L, "inMemoryDataSizeInBytes is negative: %d", inMemoryDataSizeInBytes);
        this.inMemoryDataSizeInBytes = inMemoryDataSizeInBytes;
        Preconditions.checkArgument(onDiskDataSizeInBytes >= 0L, "onDiskDataSizeInBytes is negative: %d", onDiskDataSizeInBytes);
        this.onDiskDataSizeInBytes = onDiskDataSizeInBytes;
        this.containsNumberedFileNames = containsNumberedFileNames;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public Path getWritePath() {
        return this.writePath;
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    @JsonProperty
    public List<FileWriteInfo> getFileWriteInfos() {
        return this.fileWriteInfos;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public String getJsonSerializableWritePath() {
        return this.writePath.toString();
    }

    @JsonProperty
    public long getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public long getInMemoryDataSizeInBytes() {
        return this.inMemoryDataSizeInBytes;
    }

    @JsonProperty
    public long getOnDiskDataSizeInBytes() {
        return this.onDiskDataSizeInBytes;
    }

    @JsonProperty
    public boolean containsNumberedFileNames() {
        return this.containsNumberedFileNames;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("updateMode", (Object)this.updateMode).add("writePath", this.writePath).add("targetPath", this.targetPath).add("fileWriteInfos", this.fileWriteInfos).add("rowCount", this.rowCount).add("inMemoryDataSizeInBytes", this.inMemoryDataSizeInBytes).add("onDiskDataSizeInBytes", this.onDiskDataSizeInBytes).add("containsNumberedFileNames", this.containsNumberedFileNames).toString();
    }

    public HiveBasicStatistics getStatistics() {
        return new HiveBasicStatistics(this.fileWriteInfos.size(), this.rowCount, this.inMemoryDataSizeInBytes, this.onDiskDataSizeInBytes);
    }

    public static List<PartitionUpdate> mergePartitionUpdates(Iterable<PartitionUpdate> unMergedUpdates) {
        ImmutableList.Builder partitionUpdates = ImmutableList.builder();
        for (Collection partitionGroup : ((ImmutableMap)Multimaps.index(unMergedUpdates, PartitionUpdate::getName).asMap()).values()) {
            PartitionUpdate firstPartition = (PartitionUpdate)partitionGroup.iterator().next();
            ImmutableList.Builder allFileWriterInfos = ImmutableList.builder();
            long totalRowCount = 0L;
            long totalInMemoryDataSizeInBytes = 0L;
            long totalOnDiskDataSizeInBytes = 0L;
            boolean containsNumberedFileNames = true;
            for (PartitionUpdate partition : partitionGroup) {
                if (partition.getUpdateMode() != firstPartition.getUpdateMode() || !partition.getWritePath().equals(firstPartition.getWritePath()) || !partition.getTargetPath().equals(firstPartition.getTargetPath())) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, String.format("Partition %s was added or modified during INSERT", firstPartition.getName()));
                }
                allFileWriterInfos.addAll(partition.getFileWriteInfos());
                totalRowCount += partition.getRowCount();
                totalInMemoryDataSizeInBytes += partition.getInMemoryDataSizeInBytes();
                totalOnDiskDataSizeInBytes += partition.getOnDiskDataSizeInBytes();
                containsNumberedFileNames &= partition.containsNumberedFileNames();
            }
            partitionUpdates.add(new PartitionUpdate(firstPartition.getName(), firstPartition.getUpdateMode(), firstPartition.getWritePath(), firstPartition.getTargetPath(), (List<FileWriteInfo>)((Object)allFileWriterInfos.build()), totalRowCount, totalInMemoryDataSizeInBytes, totalOnDiskDataSizeInBytes, containsNumberedFileNames));
        }
        return partitionUpdates.build();
    }

    public static class FileWriteInfo {
        private final String writeFileName;
        private final String targetFileName;
        private final Optional<Long> fileSize;

        @JsonCreator
        public FileWriteInfo(@JsonProperty(value="writeFileName") String writeFileName, @JsonProperty(value="targetFileName") String targetFileName, @JsonProperty(value="fileSize") Optional<Long> fileSize) {
            this.writeFileName = Objects.requireNonNull(writeFileName, "writeFileName is null");
            this.targetFileName = Objects.requireNonNull(targetFileName, "targetFileName is null");
            this.fileSize = Objects.requireNonNull(fileSize, "fileSize is null");
        }

        @JsonProperty
        public String getWriteFileName() {
            return this.writeFileName;
        }

        @JsonProperty
        public String getTargetFileName() {
            return this.targetFileName;
        }

        @JsonProperty
        public Optional<Long> getFileSize() {
            return this.fileSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileWriteInfo)) {
                return false;
            }
            FileWriteInfo that = (FileWriteInfo)o;
            return Objects.equals(this.writeFileName, that.writeFileName) && Objects.equals(this.targetFileName, that.targetFileName) && Objects.equals(this.fileSize, that.fileSize);
        }

        public int hashCode() {
            return Objects.hash(this.writeFileName, this.targetFileName, this.fileSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("writeFileName", this.writeFileName).add("targetFileName", this.targetFileName).add("fileSize", this.fileSize).toString();
        }
    }

    public static enum UpdateMode {
        NEW,
        APPEND,
        OVERWRITE;

    }
}

