/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class MetastoreClientConfig {
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private boolean verifyChecksum = true;
    private boolean requireHadoopNative = true;
    private Duration metastoreCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Duration metastoreRefreshInterval = new Duration(0.0, TimeUnit.SECONDS);
    private long metastoreCacheMaximumSize = 10000L;
    private long perTransactionMetastoreCacheMaximumSize = 1000L;
    private int maxMetastoreRefreshThreads = 100;
    private String recordingPath;
    private boolean replay;
    private Duration recordingDuration = new Duration(0.0, TimeUnit.MINUTES);
    private boolean partitionVersioningEnabled;
    private CachingHiveMetastore.MetastoreCacheScope metastoreCacheScope = CachingHiveMetastore.MetastoreCacheScope.ALL;
    private boolean metastoreImpersonationEnabled;
    private double partitionCacheValidationPercentage;

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public MetastoreClientConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public MetastoreClientConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public MetastoreClientConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    @NotNull
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @MinDuration(value="0ms")
    @Config(value="hive.metastore-cache-ttl")
    public MetastoreClientConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    public Duration getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @MinDuration(value="1ms")
    @Config(value="hive.metastore-refresh-interval")
    public MetastoreClientConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = metastoreRefreshInterval;
        return this;
    }

    public long getMetastoreCacheMaximumSize() {
        return this.metastoreCacheMaximumSize;
    }

    @Min(value=1L)
    @Config(value="hive.metastore-cache-maximum-size")
    public @Min(value=1L) MetastoreClientConfig setMetastoreCacheMaximumSize(long metastoreCacheMaximumSize) {
        this.metastoreCacheMaximumSize = metastoreCacheMaximumSize;
        return this;
    }

    public long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @Min(value=1L)
    @Config(value="hive.per-transaction-metastore-cache-maximum-size")
    public @Min(value=1L) MetastoreClientConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public MetastoreClientConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public String getRecordingPath() {
        return this.recordingPath;
    }

    @Config(value="hive.metastore-recording-path")
    public MetastoreClientConfig setRecordingPath(String recordingPath) {
        this.recordingPath = recordingPath;
        return this;
    }

    public boolean isReplay() {
        return this.replay;
    }

    @Config(value="hive.replay-metastore-recording")
    public MetastoreClientConfig setReplay(boolean replay) {
        this.replay = replay;
        return this;
    }

    @NotNull
    public Duration getRecordingDuration() {
        return this.recordingDuration;
    }

    @Config(value="hive.metastore-recoding-duration")
    public MetastoreClientConfig setRecordingDuration(Duration recordingDuration) {
        this.recordingDuration = recordingDuration;
        return this;
    }

    public boolean isRequireHadoopNative() {
        return this.requireHadoopNative;
    }

    @Config(value="hive.dfs.require-hadoop-native")
    public MetastoreClientConfig setRequireHadoopNative(boolean requireHadoopNative) {
        this.requireHadoopNative = requireHadoopNative;
        return this;
    }

    public boolean isPartitionVersioningEnabled() {
        return this.partitionVersioningEnabled;
    }

    @Config(value="hive.partition-versioning-enabled")
    public MetastoreClientConfig setPartitionVersioningEnabled(boolean partitionVersioningEnabled) {
        this.partitionVersioningEnabled = partitionVersioningEnabled;
        return this;
    }

    @NotNull
    public CachingHiveMetastore.MetastoreCacheScope getMetastoreCacheScope() {
        return this.metastoreCacheScope;
    }

    @Config(value="hive.metastore-cache-scope")
    public MetastoreClientConfig setMetastoreCacheScope(CachingHiveMetastore.MetastoreCacheScope metastoreCacheScope) {
        this.metastoreCacheScope = metastoreCacheScope;
        return this;
    }

    public boolean isMetastoreImpersonationEnabled() {
        return this.metastoreImpersonationEnabled;
    }

    @Config(value="hive.metastore-impersonation-enabled")
    @ConfigDescription(value="Should Presto user be impersonated when communicating with Hive Metastore")
    public MetastoreClientConfig setMetastoreImpersonationEnabled(boolean metastoreImpersonationEnabled) {
        this.metastoreImpersonationEnabled = metastoreImpersonationEnabled;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getPartitionCacheValidationPercentage() {
        return this.partitionCacheValidationPercentage;
    }

    @Config(value="hive.partition-cache-validation-percentage")
    public MetastoreClientConfig setPartitionCacheValidationPercentage(double partitionCacheValidationPercentage) {
        this.partitionCacheValidationPercentage = partitionCacheValidationPercentage;
        return this;
    }
}

