/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;

public class MaterializedViewAlreadyExistsException
extends PrestoException {
    private final SchemaTableName viewName;

    public MaterializedViewAlreadyExistsException(SchemaTableName viewName) {
        this(viewName, String.format("Materialized view already exists: '%s'", viewName));
    }

    public MaterializedViewAlreadyExistsException(SchemaTableName viewName, String message) {
        this(viewName, message, null);
    }

    public MaterializedViewAlreadyExistsException(SchemaTableName viewName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.viewName = viewName;
    }

    public SchemaTableName getViewName() {
        return this.viewName;
    }
}

