/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class LocationHandle {
    private final Path targetPath;
    private final Path writePath;
    private final Optional<Path> tempPath;
    private final TableType tableType;
    private final WriteMode writeMode;

    public LocationHandle(Path targetPath, Path writePath, Optional<Path> tempPath, TableType tableType, WriteMode writeMode) {
        if (writeMode.isWritePathSameAsTargetPath() && !targetPath.equals(writePath)) {
            throw new IllegalArgumentException(String.format("targetPath is expected to be same as writePath for writeMode %s", new Object[]{writeMode}));
        }
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.tempPath = Objects.requireNonNull(tempPath, "tempPath is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.writeMode = Objects.requireNonNull(writeMode, "writeMode is null");
    }

    @JsonCreator
    public LocationHandle(@JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="tempPath") Optional<String> tempPath, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="writeMode") WriteMode writeMode) {
        this(new Path(Objects.requireNonNull(targetPath, "targetPath is null")), new Path(Objects.requireNonNull(writePath, "writePath is null")), Objects.requireNonNull(tempPath, "tempPath is null").map(Path::new), tableType, writeMode);
    }

    Path getTargetPath() {
        return this.targetPath;
    }

    Path getWritePath() {
        return this.writePath;
    }

    Optional<Path> getTempPath() {
        return this.tempPath;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public String getJsonSerializableWritePath() {
        return this.writePath.toString();
    }

    @JsonProperty(value="tempPath")
    public Optional<String> getJsonSerializableTempPath() {
        return this.tempPath.map(Path::toString);
    }

    @JsonProperty(value="tableType")
    public TableType getJsonSerializableTableType() {
        return this.tableType;
    }

    @JsonProperty(value="writeMode")
    public WriteMode getJsonSerializableWriteMode() {
        return this.writeMode;
    }

    public static enum TableType {
        NEW,
        EXISTING,
        TEMPORARY;

    }

    public static enum WriteMode {
        STAGE_AND_MOVE_TO_TARGET_DIRECTORY(false),
        DIRECT_TO_TARGET_NEW_DIRECTORY(true),
        DIRECT_TO_TARGET_EXISTING_DIRECTORY(true);

        private final boolean writePathSameAsTargetPath;

        private WriteMode(boolean writePathSameAsTargetPath) {
            this.writePathSameAsTargetPath = writePathSameAsTargetPath;
        }

        public boolean isWritePathSameAsTargetPath() {
            return this.writePathSameAsTargetPath;
        }
    }
}

