/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveReadOnlyException;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.ParquetRecordWriterUtil;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.s3.PrestoS3FileSystem;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopExtendedFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.common.util.ReflectionUtil;

public final class HiveWriteUtils {
    private HiveWriteUtils() {
    }

    public static FileSinkOperator.RecordWriter createRecordWriter(Path target, JobConf conf, Properties properties, String outputFormatName, ConnectorSession session) {
        try {
            boolean compress = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT);
            if (outputFormatName.equals(RCFileOutputFormat.class.getName())) {
                return HiveWriteUtils.createRcFileWriter(target, conf, properties, compress);
            }
            if (outputFormatName.equals(MapredParquetOutputFormat.class.getName())) {
                return ParquetRecordWriterUtil.createParquetWriter(target, conf, properties, compress, session);
            }
            Object writer = Class.forName(outputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            return ((HiveOutputFormat)writer).getHiveRecordWriter(conf, target, Text.class, compress, properties, (Progressable)Reporter.NULL);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    private static FileSinkOperator.RecordWriter createRcFileWriter(final Path target, final JobConf conf, Properties properties, boolean compress) throws IOException {
        int columns = properties.getProperty("columns").split(",").length;
        RCFileOutputFormat.setColumnNumber((Configuration)conf, (int)columns);
        CompressionCodec codec = null;
        if (compress) {
            codec = (CompressionCodec)ReflectionUtil.newInstance((Class)FileOutputFormat.getOutputCompressorClass((JobConf)conf, DefaultCodec.class), (Configuration)conf);
        }
        final RCFile.Writer writer = new RCFile.Writer(target.getFileSystem((Configuration)conf), (Configuration)conf, target, () -> {}, codec);
        return new RecordFileWriter.ExtendedRecordWriter(){
            private long length;

            @Override
            public long getWrittenBytes() {
                return this.length;
            }

            public void write(Writable value) throws IOException {
                writer.append(value);
                this.length = writer.getLength();
            }

            public void close(boolean abort) throws IOException {
                writer.close();
                if (!abort) {
                    this.length = target.getFileSystem((Configuration)conf).getFileStatus(target).getLen();
                }
            }
        };
    }

    public static Serializer initializeSerializer(Configuration conf, Properties properties, String serializerName) {
        try {
            Serializer result = (Serializer)Class.forName(serializerName).getConstructor(new Class[0]).newInstance(new Object[0]);
            result.initialize(conf, properties);
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "Serializer does not exist: " + serializerName);
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
        }
    }

    public static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (type instanceof CharType) {
            return PrimitiveObjectInspectorFactory.writableHiveCharObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (MetastoreUtil.isArrayType(type)) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)HiveWriteUtils.getJavaObjectInspector(type.getTypeParameters().get(0)));
        }
        if (MetastoreUtil.isMapType(type)) {
            ObjectInspector keyObjectInspector = HiveWriteUtils.getJavaObjectInspector(type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = HiveWriteUtils.getJavaObjectInspector(type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (MetastoreUtil.isRowType(type)) {
            return ObjectInspectorFactory.getStandardStructObjectInspector(type.getTypeSignature().getParameters().stream().map(parameter -> parameter.getNamedTypeSignature().getName().get()).collect(Collectors.toList()), type.getTypeParameters().stream().map(HiveWriteUtils::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static void checkTableIsWritable(Table table, boolean writesToNonManagedTablesEnabled) {
        PrestoTableType tableType = table.getTableType();
        if (!(writesToNonManagedTablesEnabled || tableType.equals((Object)PrestoTableType.MANAGED_TABLE) || tableType.equals((Object)PrestoTableType.MATERIALIZED_VIEW) || tableType.equals((Object)PrestoTableType.TEMPORARY_TABLE))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to non-managed Hive table");
        }
        HiveWriteUtils.checkWritable(new SchemaTableName(table.getDatabaseName(), table.getTableName()), Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters(), table.getStorage());
    }

    public static void checkPartitionIsWritable(String partitionName, Partition partition) {
        HiveWriteUtils.checkWritable(new SchemaTableName(partition.getDatabaseName(), partition.getTableName()), Optional.of(partitionName), MetastoreUtil.getProtectMode(partition), partition.getParameters(), partition.getStorage());
    }

    private static void checkWritable(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters, Storage storage) {
        String tablePartitionDescription = "Table '" + tableName + "'";
        if (partitionName.isPresent()) {
            tablePartitionDescription = tablePartitionDescription + " partition '" + partitionName.get() + "'";
        }
        MetastoreUtil.verifyOnline(tableName, partitionName, protectMode, parameters);
        if (protectMode.readOnly) {
            throw new HiveReadOnlyException(tableName, partitionName);
        }
        if (storage.isSkewed()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into bucketed tables with skew is not supported. %s", tablePartitionDescription));
        }
    }

    public static Path getTableDefaultLocation(ConnectorSession session, SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, String schemaName, String tableName) {
        Path databasePath;
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource());
        Optional<String> location = HiveWriteUtils.getDatabase(session.getIdentity(), metastoreContext, metastore, schemaName).getLocation();
        if (!location.isPresent() || location.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not set", schemaName));
        }
        HdfsContext context = new HdfsContext(session, schemaName, tableName, location.get(), true);
        if (!HiveWriteUtils.isS3FileSystem(context, hdfsEnvironment, databasePath = new Path(location.get()))) {
            if (!MetastoreUtil.pathExists(context, hdfsEnvironment, databasePath)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
            }
            if (!HiveWriteUtils.isDirectory(context, hdfsEnvironment, databasePath)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
            }
        }
        return new Path(databasePath, tableName);
    }

    private static Database getDatabase(ConnectorIdentity identity, MetastoreContext metastoreContext, SemiTransactionalHiveMetastore metastore, String database) {
        return metastore.getDatabase(metastoreContext, database).orElseThrow(() -> new SchemaNotFoundException(database));
    }

    public static boolean isS3FileSystem(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return HiveWriteUtils.getRawFileSystem(hdfsEnvironment.getFileSystem(context, path)) instanceof PrestoS3FileSystem;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static boolean isViewFileSystem(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return HiveWriteUtils.getRawFileSystem(hdfsEnvironment.getFileSystem(context, path)) instanceof ViewFileSystem;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    private static FileSystem getRawFileSystem(FileSystem fileSystem) {
        if (fileSystem instanceof HadoopExtendedFileSystem) {
            return HiveWriteUtils.getRawFileSystem(((HadoopExtendedFileSystem)fileSystem).getRawFileSystem());
        }
        return fileSystem;
    }

    private static boolean isDirectory(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            return hdfsEnvironment.getFileSystem(context, path).isDirectory(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    public static Path createTemporaryPath(ConnectorSession session, HdfsContext context, HdfsEnvironment hdfsEnvironment, Path targetPath) {
        Path temporaryRoot;
        String temporaryPrefix = HiveSessionProperties.getTemporaryStagingDirectoryPath(session).replace("${USER}", context.getIdentity().getUser());
        if (HiveWriteUtils.isViewFileSystem(context, hdfsEnvironment, targetPath)) {
            temporaryPrefix = MetastoreUtil.pathExists(context, hdfsEnvironment, targetPath) ? ".hive-staging" : "../.hive-staging";
        }
        if (!MetastoreUtil.pathExists(context, hdfsEnvironment, temporaryRoot = new Path(targetPath, temporaryPrefix))) {
            MetastoreUtil.createDirectory(context, hdfsEnvironment, temporaryRoot);
        }
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        MetastoreUtil.createDirectory(context, hdfsEnvironment, temporaryPath);
        return temporaryPath;
    }

    public static boolean isWritableType(HiveType hiveType) {
        return HiveWriteUtils.isWritableType(hiveType.getTypeInfo());
    }

    private static boolean isWritableType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                return HiveWriteUtils.isWritablePrimitiveType(primitiveCategory);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return HiveWriteUtils.isWritableType(mapTypeInfo.getMapKeyTypeInfo()) && HiveWriteUtils.isWritableType(mapTypeInfo.getMapValueTypeInfo());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return HiveWriteUtils.isWritableType(listTypeInfo.getListElementTypeInfo());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(HiveWriteUtils::isWritableType);
            }
        }
        return false;
    }

    private static boolean isWritablePrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: 
            case LONG: 
            case INT: 
            case SHORT: 
            case BYTE: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIMESTAMP: 
            case BINARY: 
            case DECIMAL: 
            case VARCHAR: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static List<ObjectInspector> getRowColumnInspectors(List<Type> types) {
        return types.stream().map(HiveWriteUtils::getRowColumnInspector).collect(Collectors.toList());
    }

    public static ObjectInspector getRowColumnInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            if (varcharLength <= 65535) {
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)varcharLength));
            }
            if (varcharLength == Integer.MAX_VALUE) {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
        }
        if (Chars.isCharType(type)) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)charLength));
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (MetastoreUtil.isArrayType(type) || MetastoreUtil.isMapType(type) || MetastoreUtil.isRowType(type)) {
            return HiveWriteUtils.getJavaObjectInspector(type);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static FieldSetter createFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanFieldSetter(rowInspector, row, field);
        }
        if (type.equals(BigintType.BIGINT)) {
            return new BigintFieldBuilder(rowInspector, row, field);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new IntFieldSetter(rowInspector, row, field);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new SmallintFieldSetter(rowInspector, row, field);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new TinyintFieldSetter(rowInspector, row, field);
        }
        if (type.equals(RealType.REAL)) {
            return new FloatFieldSetter(rowInspector, row, field);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleFieldSetter(rowInspector, row, field);
        }
        if (type instanceof VarcharType) {
            return new VarcharFieldSetter(rowInspector, row, field, type);
        }
        if (type instanceof CharType) {
            return new CharFieldSetter(rowInspector, row, field, type);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new BinaryFieldSetter(rowInspector, row, field);
        }
        if (type.equals(DateType.DATE)) {
            return new DateFieldSetter(rowInspector, row, field);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new TimestampFieldSetter(rowInspector, row, field);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalFieldSetter(rowInspector, row, field, decimalType);
        }
        if (MetastoreUtil.isArrayType(type)) {
            return new ArrayFieldSetter(rowInspector, row, field, type.getTypeParameters().get(0));
        }
        if (MetastoreUtil.isMapType(type)) {
            return new MapFieldSetter(rowInspector, row, field, type.getTypeParameters().get(0), type.getTypeParameters().get(1));
        }
        if (MetastoreUtil.isRowType(type)) {
            return new RowFieldSetter(rowInspector, row, field, type.getTypeParameters());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static class RowFieldSetter
    extends FieldSetter {
        private final List<Type> fieldTypes;

        public RowFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, List<Type> fieldTypes) {
            super(rowInspector, row, field);
            this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        }

        @Override
        public void setField(Block block, int position) {
            Block rowBlock = block.getBlock(position);
            ArrayList<Object> value = new ArrayList<Object>(this.fieldTypes.size());
            for (int i = 0; i < this.fieldTypes.size(); ++i) {
                Object element = MetastoreUtil.getField(this.fieldTypes.get(i), rowBlock, i);
                value.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, value);
        }
    }

    private static class MapFieldSetter
    extends FieldSetter {
        private final Type keyType;
        private final Type valueType;

        public MapFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type keyType, Type valueType) {
            super(rowInspector, row, field);
            this.keyType = Objects.requireNonNull(keyType, "keyType is null");
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block mapBlock = block.getBlock(position);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = MetastoreUtil.getField(this.keyType, mapBlock, i);
                Object value = MetastoreUtil.getField(this.valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, map);
        }
    }

    private static class ArrayFieldSetter
    extends FieldSetter {
        private final Type elementType;

        public ArrayFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type elementType) {
            super(rowInspector, row, field);
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block arrayBlock = block.getBlock(position);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = MetastoreUtil.getField(this.elementType, arrayBlock, i);
                list.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, list);
        }
    }

    private static class DecimalFieldSetter
    extends FieldSetter {
        private final HiveDecimalWritable value = new HiveDecimalWritable();
        private final DecimalType decimalType;

        public DecimalFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, DecimalType decimalType) {
            super(rowInspector, row, field);
            this.decimalType = decimalType;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(MetastoreUtil.getHiveDecimal(this.decimalType, block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TimestampFieldSetter
    extends FieldSetter {
        private final TimestampWritable value = new TimestampWritable();

        public TimestampFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            long millisUtc = TimestampType.TIMESTAMP.getLong(block, position);
            this.value.setTime(millisUtc);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DateFieldSetter
    extends FieldSetter {
        private final DateWritable value = new DateWritable();

        public DateFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(DateType.DATE.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BinaryFieldSetter
    extends FieldSetter {
        private final BytesWritable value = new BytesWritable();

        public BinaryFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            byte[] bytes = VarbinaryType.VARBINARY.getSlice(block, position).getBytes();
            this.value.set(bytes, 0, bytes.length);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class CharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public CharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class VarcharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public VarcharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class FloatFieldSetter
    extends FieldSetter {
        private final FloatWritable value = new FloatWritable();

        public FloatFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Float.intBitsToFloat((int)RealType.REAL.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DoubleFieldSetter
    extends FieldSetter {
        private final DoubleWritable value = new DoubleWritable();

        public DoubleFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(DoubleType.DOUBLE.getDouble(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TinyintFieldSetter
    extends FieldSetter {
        private final ByteWritable value = new ByteWritable();

        public TinyintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(SignedBytes.checkedCast(TinyintType.TINYINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class SmallintFieldSetter
    extends FieldSetter {
        private final ShortWritable value = new ShortWritable();

        public SmallintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Shorts.checkedCast(SmallintType.SMALLINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class IntFieldSetter
    extends FieldSetter {
        private final IntWritable value = new IntWritable();

        public IntFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(IntegerType.INTEGER.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BigintFieldBuilder
    extends FieldSetter {
        private final LongWritable value = new LongWritable();

        public BigintFieldBuilder(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BigintType.BIGINT.getLong(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BooleanFieldSetter
    extends FieldSetter {
        private final BooleanWritable value = new BooleanWritable();

        public BooleanFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BooleanType.BOOLEAN.getBoolean(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    public static abstract class FieldSetter {
        protected final SettableStructObjectInspector rowInspector;
        protected final Object row;
        protected final StructField field;

        protected FieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            this.rowInspector = Objects.requireNonNull(rowInspector, "rowInspector is null");
            this.row = Objects.requireNonNull(row, "row is null");
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public abstract void setField(Block var1, int var2);
    }
}

