/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForFileRename;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HiveStagingFileCommitter
implements StagingFileCommitter {
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService fileRenameExecutor;

    @Inject
    public HiveStagingFileCommitter(HdfsEnvironment hdfsEnvironment, @ForFileRename ListeningExecutorService fileRenameExecutor) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileRenameExecutor = Objects.requireNonNull(fileRenameExecutor, "fileRenameExecutor is null");
    }

    @Override
    public ListenableFuture<Void> commitFiles(ConnectorSession session, String schemaName, String tableName, String tablePath, boolean isCreateTable, List<PartitionUpdate> partitionUpdates) {
        HdfsContext context = new HdfsContext(session, schemaName, tableName, tablePath, isCreateTable);
        ArrayList<Future> commitFutures = new ArrayList<Future>();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            Path path = partitionUpdate.getWritePath();
            FileSystem fileSystem = MetastoreUtil.getFileSystem(this.hdfsEnvironment, context, path);
            for (PartitionUpdate.FileWriteInfo fileWriteInfo : partitionUpdate.getFileWriteInfos()) {
                Preconditions.checkState(!fileWriteInfo.getWriteFileName().equals(fileWriteInfo.getTargetFileName()));
                Path source = new Path(path, fileWriteInfo.getWriteFileName());
                Path target = new Path(path, fileWriteInfo.getTargetFileName());
                commitFutures.add(this.fileRenameExecutor.submit(() -> {
                    MetastoreUtil.renameFile(fileSystem, source, target);
                    return null;
                }));
            }
        }
        ListenableFuture<Void> result = Futures.whenAllSucceed(commitFutures).call(() -> null, MoreExecutors.directExecutor());
        return Futures.catching(result, RuntimeException.class, e -> {
            Preconditions.checkState(e != null, "Null exception is caught during commitFiles");
            result.cancel(true);
            throw e;
        }, MoreExecutors.directExecutor());
    }
}

