/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class HivePartitioningHandle
implements ConnectorPartitioningHandle {
    private final int bucketCount;
    private final OptionalInt maxCompatibleBucketCount;
    private final BucketFunctionType bucketFunctionType;
    private final Optional<List<HiveType>> hiveTypes;
    private final Optional<List<Type>> types;

    public static HivePartitioningHandle createHiveCompatiblePartitioningHandle(int bucketCount, List<HiveType> hiveTypes, OptionalInt maxCompatibleBucketCount) {
        return new HivePartitioningHandle(bucketCount, maxCompatibleBucketCount, BucketFunctionType.HIVE_COMPATIBLE, Optional.of(hiveTypes), Optional.empty());
    }

    public static HivePartitioningHandle createPrestoNativePartitioningHandle(int bucketCount, List<Type> types, OptionalInt maxCompatibleBucketCount) {
        return new HivePartitioningHandle(bucketCount, maxCompatibleBucketCount, BucketFunctionType.PRESTO_NATIVE, Optional.empty(), Optional.of(types));
    }

    @JsonCreator
    public HivePartitioningHandle(@JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="maxCompatibleBucketCount") OptionalInt maxCompatibleBucketCount, @JsonProperty(value="bucketFunctionType") BucketFunctionType bucketFunctionType, @JsonProperty(value="hiveTypes") Optional<List<HiveType>> hiveTypes, @JsonProperty(value="types") Optional<List<Type>> types) {
        this.bucketCount = bucketCount;
        this.maxCompatibleBucketCount = maxCompatibleBucketCount;
        this.bucketFunctionType = Objects.requireNonNull(bucketFunctionType, "bucketFunctionType is null");
        this.hiveTypes = Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        this.types = Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument(bucketFunctionType.equals((Object)BucketFunctionType.HIVE_COMPATIBLE) && hiveTypes.isPresent() && !types.isPresent() || bucketFunctionType.equals((Object)BucketFunctionType.PRESTO_NATIVE) && !hiveTypes.isPresent() && types.isPresent(), "Type list for bucketFunctionType %s is missing or duplicated. hiveTypes: %s, types: %s", (Object)bucketFunctionType, hiveTypes, types);
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public Optional<List<HiveType>> getHiveTypes() {
        return this.hiveTypes;
    }

    @JsonProperty
    public Optional<List<Type>> getTypes() {
        return this.types;
    }

    @JsonProperty
    public OptionalInt getMaxCompatibleBucketCount() {
        return this.maxCompatibleBucketCount;
    }

    @JsonProperty
    public BucketFunctionType getBucketFunctionType() {
        return this.bucketFunctionType;
    }

    public String toString() {
        return String.format("buckets=%s, bucketFunctionType=%s, types=%s", new Object[]{this.bucketCount, this.bucketFunctionType, this.bucketFunctionType.equals((Object)BucketFunctionType.HIVE_COMPATIBLE) ? this.hiveTypes.get() : this.types.get()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePartitioningHandle that = (HivePartitioningHandle)o;
        return this.bucketCount == that.bucketCount && this.bucketFunctionType.equals((Object)that.bucketFunctionType) && Objects.equals(this.hiveTypes, that.hiveTypes) && Objects.equals(this.types, that.types);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketCount, this.bucketFunctionType, this.hiveTypes, this.types});
    }
}

