/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class HivePartitionManager {
    private final DateTimeZone timeZone;
    private final boolean assumeCanonicalPartitionKeys;
    private final TypeManager typeManager;
    private final int maxPartitionsPerScan;
    private final int domainCompactionThreshold;

    @Inject
    public HivePartitionManager(TypeManager typeManager, HiveClientConfig hiveClientConfig) {
        this(typeManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), hiveClientConfig.getMaxPartitionsPerScan(), hiveClientConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(TypeManager typeManager, DateTimeZone timeZone, boolean assumeCanonicalPartitionKeys, int maxPartitionsPerScan, int domainCompactionThreshold) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        Preconditions.checkArgument(domainCompactionThreshold >= 1, "domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public Iterable<HivePartition> getPartitionsIterator(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicateColumnHandles = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        Map<Column, Domain> effectivePredicate = this.createPartitionPredicates(effectivePredicateColumnHandles, partitionColumns, this.assumeCanonicalPartitionKeys);
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of(new HivePartition(tableName));
        }
        return () -> {
            List<String> filteredPartitionNames = this.getFilteredPartitionNames(session, metastore, tableName, effectivePredicate);
            return filteredPartitionNames.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, constraint)).filter(Optional::isPresent).map(Optional::get).iterator();
        };
    }

    private Map<Column, Domain> createPartitionPredicates(TupleDomain<ColumnHandle> effectivePredicateColumnHandles, List<HiveColumnHandle> partitionColumns, boolean assumeCanonicalPartitionKeys) {
        Optional<Map<ColumnHandle, Domain>> domains = effectivePredicateColumnHandles.getDomains();
        if (domains.isPresent()) {
            Map<ColumnHandle, Domain> columnHandleDomainMap = domains.get();
            ImmutableMap.Builder<Column, Domain> partitionPredicateBuilder = ImmutableMap.builder();
            for (HiveColumnHandle partitionColumn : partitionColumns) {
                Column key = new Column(partitionColumn.getName(), partitionColumn.getHiveType(), partitionColumn.getComment());
                if (columnHandleDomainMap.containsKey(partitionColumn)) {
                    if (assumeCanonicalPartitionKeys) {
                        partitionPredicateBuilder.put(key, columnHandleDomainMap.get(partitionColumn));
                        continue;
                    }
                    Type type = this.typeManager.getType(partitionColumn.getTypeSignature());
                    if (type instanceof VarcharType || type instanceof CharType) {
                        partitionPredicateBuilder.put(key, columnHandleDomainMap.get(partitionColumn));
                        continue;
                    }
                    Domain allDomain = Domain.all(this.typeManager.getType(partitionColumn.getTypeSignature()));
                    partitionPredicateBuilder.put(key, allDomain);
                    continue;
                }
                Domain allDomain = Domain.all(this.typeManager.getType(partitionColumn.getTypeSignature()));
                partitionPredicateBuilder.put(key, allDomain);
            }
            return partitionPredicateBuilder.build();
        }
        return ImmutableMap.of();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List<HivePartition> partitions = this.getPartitionsAsList(this.getPartitionsIterator(metastore, tableHandle, constraint, session).iterator());
        Optional<HiveBucketHandle> hiveBucketHandle = this.getBucketHandle(table, session, effectivePredicate);
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = hiveBucketHandle.flatMap(value -> HiveBucketing.getHiveBucketFilter(table, effectivePredicate));
        if (!this.queryUsesHiveBucketColumn(effectivePredicate) && hiveBucketHandle.isPresent() && this.queryAccessesTooManyBuckets(hiveBucketHandle.get(), bucketFilter, partitions, session)) {
            hiveBucketHandle = Optional.empty();
            bucketFilter = Optional.empty();
        }
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, TupleDomain.none(), TupleDomain.none(), TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        TupleDomain compactEffectivePredicate = effectivePredicate.compact(this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, compactEffectivePredicate, effectivePredicate, TupleDomain.all(), hiveBucketHandle, bucketFilter);
        }
        TupleDomain<ColumnHandle> remainingTupleDomain = TupleDomain.withColumnDomains(Maps.filterKeys(effectivePredicate.getDomains().get(), Predicates.not(Predicates.in(partitionColumns))));
        TupleDomain<ColumnHandle> enforcedTupleDomain = TupleDomain.withColumnDomains(Maps.filterKeys(effectivePredicate.getDomains().get(), Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, compactEffectivePredicate, remainingTupleDomain, enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    private Optional<HiveBucketHandle> getBucketHandle(Table table, ConnectorSession session, TupleDomain<ColumnHandle> effectivePredicate) {
        if (table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
            return HiveBucketing.getHiveBucketHandle(table);
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent() || HiveSessionProperties.shouldIgnoreTableBucketing(session)) {
            return Optional.empty();
        }
        if (this.queryUsesHiveBucketColumn(effectivePredicate)) {
            return hiveBucketHandle;
        }
        int requiredTableBucketCount = HiveSessionProperties.getMinBucketCountToNotIgnoreTableBucketing(session);
        if (hiveBucketHandle.get().getTableBucketCount() < requiredTableBucketCount) {
            return Optional.empty();
        }
        return hiveBucketHandle;
    }

    private boolean queryUsesHiveBucketColumn(TupleDomain<ColumnHandle> effectivePredicate) {
        if (!effectivePredicate.getDomains().isPresent()) {
            return false;
        }
        return effectivePredicate.getDomains().get().keySet().stream().anyMatch(key -> ((HiveColumnHandle)key).getName().equals("$bucket"));
    }

    private boolean queryAccessesTooManyBuckets(HiveBucketHandle handle, Optional<HiveBucketing.HiveBucketFilter> filter, List<HivePartition> partitions, ConnectorSession session) {
        int bucketsPerPartition = filter.map(hiveBucketFilter -> hiveBucketFilter.getBucketsToKeep().size()).orElseGet(handle::getReadBucketCount);
        return bucketsPerPartition * partitions.size() > HiveSessionProperties.getMaxBucketsForGroupedExecution(session);
    }

    private List<HivePartition> getPartitionsAsList(Iterator<HivePartition> partitionsIterator) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        while (partitionsIterator.hasNext()) {
            HivePartition partition = partitionsIterator.next();
            if (count == this.maxPartitionsPerScan) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitionsPerScan));
            }
            partitionList.add(partition);
            ++count;
        }
        return partitionList.build();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionColumnTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(ImmutableList.toImmutableList());
        List partitionList = partitionValuesList.stream().map(partitionValues -> MetastoreUtil.makePartName(table.getPartitionColumns(), partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionColumnTypes, (Constraint<ColumnHandle>)Constraint.alwaysTrue())).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        Optional<HiveBucketHandle> bucketHandle = HiveSessionProperties.shouldIgnoreTableBucketing(session) ? Optional.empty() : HiveBucketing.getHiveBucketHandle(table);
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitionList, TupleDomain.all(), TupleDomain.all(), TupleDomain.none(), bucketHandle, Optional.empty());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, Constraint<ColumnHandle> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns, partitionColumnTypes, this.timeZone);
        Map domains = constraint.getSummary().getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = partition.getKeys().get(column);
            Domain allowedDomain = domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return Optional.empty();
        }
        if (constraint.predicate().isPresent() && !((Predicate)constraint.predicate().get()).test(partition.getKeys())) {
            return Optional.empty();
        }
        return Optional.of(partition);
    }

    private Table getTable(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, boolean offlineDataDebugModeEnabled) {
        Optional<Table> target = metastore.getTable(new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource()), tableName.getSchemaName(), tableName.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        if (!offlineDataDebugModeEnabled) {
            MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table), table.getParameters());
        }
        return table;
    }

    private List<String> getFilteredPartitionNames(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, Map<Column, Domain> partitionPredicates) {
        if (partitionPredicates.isEmpty()) {
            return ImmutableList.of();
        }
        return metastore.getPartitionNamesByFilter(new MetastoreContext(session.getIdentity(), session.getQueryId(), (Optional<String>)session.getClientInfo(), (Optional<String>)session.getSource()), tableName.getSchemaName(), tableName.getTableName(), partitionPredicates).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, DateTimeZone timeZone) {
        List partitionColumnNames = partitionColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        List<String> partitionValues = MetastoreUtil.extractPartitionValues(partitionName, Optional.of(partitionColumnNames));
        ImmutableMap.Builder<HiveColumnHandle, NullableValue> builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), partitionColumnTypes.get(i), timeZone);
            builder.put(column, parsedValue);
        }
        ImmutableMap<ColumnHandle, NullableValue> values = builder.build();
        return new HivePartition(tableName, partitionName, values);
    }
}

