/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.IntArrayBlockBuilder;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketFunction;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveMetadataUpdater;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveWriter;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageIndexer;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;

public class HivePageSink
implements ConnectorPageSink {
    private static final Logger log = Logger.get(HivePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final HiveWriterFactory writerFactory;
    private final String schemaName;
    private final String tableName;
    private final int[] dataColumnInputIndex;
    private final int[] partitionColumnsInputIndex;
    private final int[] bucketColumns;
    private final HiveBucketFunction bucketFunction;
    private final HiveWriterPagePartitioner pagePartitioner;
    private final HdfsEnvironment hdfsEnvironment;
    private final int maxOpenWriters;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final SmileCodec<PartitionUpdate> partitionUpdateSmileCodec;
    private final List<HiveWriter> writers = new ArrayList<HiveWriter>();
    private final ConnectorSession session;
    private final HiveMetadataUpdater hiveMetadataUpdater;
    private final boolean fileRenamingEnabled;
    private long writtenBytes;
    private long systemMemoryUsage;
    private long validationCpuNanos;
    private boolean waitForFileRenaming;

    public HivePageSink(HiveWriterFactory writerFactory, List<HiveColumnHandle> inputColumns, Optional<HiveBucketProperty> bucketProperty, String schemaName, String tableName, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, int maxOpenWriters, ListeningExecutorService writeVerificationExecutor, JsonCodec<PartitionUpdate> partitionUpdateCodec, SmileCodec<PartitionUpdate> partitionUpdateSmileCodec, ConnectorSession session, HiveMetadataUpdater hiveMetadataUpdater) {
        this.writerFactory = Objects.requireNonNull(writerFactory, "writerFactory is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.maxOpenWriters = maxOpenWriters;
        this.writeVerificationExecutor = Objects.requireNonNull(writeVerificationExecutor, "writeVerificationExecutor is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.partitionUpdateSmileCodec = Objects.requireNonNull(partitionUpdateSmileCodec, "partitionUpdateSmileCodec is null");
        Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.pagePartitioner = new HiveWriterPagePartitioner(inputColumns, bucketProperty.isPresent(), pageIndexerFactory, typeManager);
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object2IntOpenHashMap dataColumnNameToIdMap = new Object2IntOpenHashMap();
        HashMap<String, HiveType> dataColumnNameToHiveTypeMap = new HashMap<String, HiveType>();
        for (int inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            HiveColumnHandle column = inputColumns.get(inputIndex);
            if (column.isPartitionKey()) {
                partitionColumns.add((Object)inputIndex);
                continue;
            }
            dataColumnsInputIndex.add((Object)inputIndex);
            dataColumnNameToIdMap.put((Object)column.getName(), inputIndex);
            dataColumnNameToHiveTypeMap.put(column.getName(), column.getHiveType());
        }
        this.partitionColumnsInputIndex = Ints.toArray(partitionColumns.build());
        this.dataColumnInputIndex = Ints.toArray(dataColumnsInputIndex.build());
        if (bucketProperty.isPresent()) {
            int bucketCount = bucketProperty.get().getBucketCount();
            this.bucketColumns = bucketProperty.get().getBucketedBy().stream().mapToInt(arg_0 -> ((Object2IntMap)dataColumnNameToIdMap).get(arg_0)).toArray();
            BucketFunctionType bucketFunctionType = bucketProperty.get().getBucketFunctionType();
            switch (bucketFunctionType) {
                case HIVE_COMPATIBLE: {
                    List bucketColumnHiveTypes = bucketProperty.get().getBucketedBy().stream().map(dataColumnNameToHiveTypeMap::get).collect(ImmutableList.toImmutableList());
                    this.bucketFunction = HiveBucketFunction.createHiveCompatibleBucketFunction(bucketCount, bucketColumnHiveTypes);
                    break;
                }
                case PRESTO_NATIVE: {
                    this.bucketFunction = HiveBucketFunction.createPrestoNativeBucketFunction(bucketCount, bucketProperty.get().getTypes().get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported bucket function type " + (Object)((Object)bucketFunctionType));
                }
            }
        } else {
            this.bucketColumns = null;
            this.bucketFunction = null;
        }
        this.session = Objects.requireNonNull(session, "session is null");
        this.hiveMetadataUpdater = Objects.requireNonNull(hiveMetadataUpdater, "hiveMetadataUpdater is null");
        this.fileRenamingEnabled = HiveSessionProperties.isFileRenamingEnabled(session);
    }

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryUsage;
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ListenableFuture result = this.hdfsEnvironment.doAs(this.session.getUser(), this::doFinish);
        return MoreFutures.toCompletableFuture((ListenableFuture)result);
    }

    private ListenableFuture<Collection<Slice>> doFinish() {
        ImmutableList.Builder partitionUpdatesBuilder = ImmutableList.builder();
        ArrayList verificationTasks = new ArrayList();
        for (HiveWriter writer : this.writers) {
            writer.commit();
            partitionUpdatesBuilder.add(writer.getPartitionUpdate());
            writer.getVerificationTask().map(Executors::callable).ifPresent(verificationTasks::add);
        }
        Collection<Object> partitionUpdates = partitionUpdatesBuilder.build();
        boolean optimizedPartitionUpdateSerializationEnabled = HiveSessionProperties.isOptimizedPartitionUpdateSerializationEnabled(this.session);
        if (optimizedPartitionUpdateSerializationEnabled) {
            partitionUpdates = PartitionUpdate.mergePartitionUpdates((Iterable<PartitionUpdate>)partitionUpdates);
        }
        ImmutableList.Builder serializedPartitionUpdatesBuilder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            byte[] serializedBytes = optimizedPartitionUpdateSerializationEnabled ? HiveUtil.serializeZstdCompressed(this.partitionUpdateSmileCodec, partitionUpdate) : this.partitionUpdateCodec.toBytes((Object)partitionUpdate);
            serializedPartitionUpdatesBuilder.add(Slices.wrappedBuffer(serializedBytes));
        }
        ImmutableCollection serializedPartitionUpdates = serializedPartitionUpdatesBuilder.build();
        this.writtenBytes = this.writers.stream().mapToLong(HiveWriter::getWrittenBytes).sum();
        this.validationCpuNanos = this.writers.stream().mapToLong(HiveWriter::getValidationCpuNanos).sum();
        if (this.waitForFileRenaming && verificationTasks.isEmpty()) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            ArrayList futures = new ArrayList();
            int i = 0;
            while (i < this.writers.size()) {
                int writerIndex = i++;
                ListenableFuture fileNameFuture = MoreFutures.toListenableFuture(this.hiveMetadataUpdater.getMetadataResult(writerIndex));
                SettableFuture renamingFuture = SettableFuture.create();
                futures.add(renamingFuture);
                MoreFutures.addSuccessCallback((ListenableFuture)fileNameFuture, obj -> this.renameFiles((String)obj, writerIndex, renamingFuture, partitionUpdatesWithRenamedFileNames));
            }
            return Futures.transform(Futures.allAsList(futures), input -> partitionUpdatesWithRenamedFileNames, MoreExecutors.directExecutor());
        }
        if (verificationTasks.isEmpty()) {
            return Futures.immediateFuture(serializedPartitionUpdates);
        }
        try {
            List list = this.writeVerificationExecutor.invokeAll(verificationTasks).stream().map(future -> (ListenableFuture)future).collect(Collectors.toList());
            return Futures.transform(Futures.allAsList(list), arg_0 -> HivePageSink.lambda$doFinish$3((List)((Object)serializedPartitionUpdates), arg_0), MoreExecutors.directExecutor());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    public void abort() {
        this.hdfsEnvironment.doAs(this.session.getUser(), this::doAbort);
    }

    private void doAbort() {
        Optional<Object> rollbackException = Optional.empty();
        for (HiveWriter writer : this.writers) {
            if (writer == null) continue;
            try {
                writer.rollback();
            }
            catch (Exception e) {
                log.warn("exception '%s' while rollback on %s", e, writer);
                rollbackException = Optional.of(e);
            }
        }
        if (rollbackException.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)rollbackException.get());
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        if (page.getPositionCount() > 0) {
            this.hdfsEnvironment.doAs(this.session.getUser(), () -> this.doAppend(page));
        }
        return NOT_BLOCKED;
    }

    private void doAppend(Page page) {
        while (page.getPositionCount() > 4096) {
            Page chunk = page.getRegion(0, 4096);
            page = page.getRegion(4096, page.getPositionCount() - 4096);
            this.writePage(chunk);
        }
        this.writePage(page);
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify(positions.length == counts[index]);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            HiveWriter writer = this.writers.get(index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getSystemMemoryUsage();
            writer.append(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.systemMemoryUsage += writer.getSystemMemoryUsage() - currentMemory;
        }
    }

    private void sendMetadataUpdateRequest(Optional<String> partitionName, int writerIndex, boolean writeTempData) {
        if (writeTempData || !this.fileRenamingEnabled || this.bucketFunction != null) {
            return;
        }
        this.hiveMetadataUpdater.addMetadataUpdateRequest(this.schemaName, this.tableName, partitionName, writerIndex);
        this.waitForFileRenaming = true;
    }

    private void renameFiles(String fileName, int writerIndex, SettableFuture<?> renamingFuture, List<Slice> partitionUpdatesWithRenamedFileNames) {
        HdfsContext context = new HdfsContext(this.session, this.schemaName, this.tableName, this.writerFactory.getLocationHandle().getTargetPath().toString(), this.writerFactory.isCreateTable());
        HiveWriter writer = this.writers.get(writerIndex);
        PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
        Preconditions.checkArgument(partitionUpdate.getFileWriteInfos().size() == 1, "HiveWriter wrote data to more than one file");
        PartitionUpdate.FileWriteInfo fileWriteInfo = partitionUpdate.getFileWriteInfos().get(0);
        Path fromPath = new Path(partitionUpdate.getWritePath(), fileWriteInfo.getWriteFileName());
        Path toPath = new Path(partitionUpdate.getWritePath(), fileName);
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(context, fromPath);
            ListenableFuture<Void> asyncFuture = fileSystem.renameFileAsync(fromPath, toPath);
            MoreFutures.addSuccessCallback(asyncFuture, () -> this.updateFileInfo(partitionUpdatesWithRenamedFileNames, renamingFuture, partitionUpdate, fileName, fileWriteInfo, writerIndex));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error renaming file. fromPath: %s toPath: %s", fromPath, toPath), (Throwable)e);
        }
    }

    private void updateFileInfo(List<Slice> partitionUpdatesWithRenamedFileNames, SettableFuture<?> renamingFuture, PartitionUpdate partitionUpdate, String fileName, PartitionUpdate.FileWriteInfo fileWriteInfo, int writerIndex) {
        PartitionUpdate.FileWriteInfo fileInfoWithRenamedFileName = new PartitionUpdate.FileWriteInfo(fileName, fileName, fileWriteInfo.getFileSize());
        PartitionUpdate partitionUpdateWithRenamedFileName = new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), ImmutableList.of(fileInfoWithRenamedFileName), partitionUpdate.getRowCount(), partitionUpdate.getInMemoryDataSizeInBytes(), partitionUpdate.getOnDiskDataSizeInBytes(), true);
        partitionUpdatesWithRenamedFileNames.add(Slices.wrappedBuffer(this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdateWithRenamedFileName)));
        this.hiveMetadataUpdater.removeResultFuture(writerIndex);
        renamingFuture.set(null);
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = HivePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        Block bucketBlock = this.buildBucketBlock(page);
        int[] writerIndexes = this.pagePartitioner.partitionPage(partitionColumns, bucketBlock);
        if (this.pagePartitioner.getMaxIndex() >= this.maxOpenWriters) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, String.format("Exceeded limit of %s open writers for partitions/buckets", this.maxOpenWriters));
        }
        while (this.writers.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writers.add(null);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            if (this.writers.get(writerIndex) != null) continue;
            OptionalInt bucketNumber = OptionalInt.empty();
            if (bucketBlock != null) {
                bucketNumber = OptionalInt.of(bucketBlock.getInt(position));
            }
            HiveWriter writer = this.writerFactory.createWriter(partitionColumns, position, bucketNumber);
            this.writers.set(writerIndex, writer);
            this.sendMetadataUpdateRequest(writer.getPartitionName(), writerIndex, writer.isWriteTempData());
        }
        Verify.verify(this.writers.size() == this.pagePartitioner.getMaxIndex() + 1);
        Verify.verify(!this.writers.contains(null));
        return writerIndexes;
    }

    private Page getDataPage(Page page) {
        Block[] blocks = new Block[this.dataColumnInputIndex.length];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private Block buildBucketBlock(Page page) {
        if (this.bucketFunction == null) {
            return null;
        }
        IntArrayBlockBuilder bucketColumnBuilder = new IntArrayBlockBuilder(null, page.getPositionCount());
        Page bucketColumnsPage = HivePageSink.extractColumns(page, this.bucketColumns);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int bucket = this.bucketFunction.getBucket(bucketColumnsPage, position);
            bucketColumnBuilder.writeInt(bucket);
        }
        return bucketColumnBuilder.build();
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private static /* synthetic */ Collection lambda$doFinish$3(List serializedPartitionUpdates, List input) {
        return serializedPartitionUpdates;
    }

    private static class HiveWriterPagePartitioner {
        private final PageIndexer pageIndexer;

        public HiveWriterPagePartitioner(List<HiveColumnHandle> inputColumns, boolean bucketed, PageIndexerFactory pageIndexerFactory, TypeManager typeManager) {
            Objects.requireNonNull(inputColumns, "inputColumns is null");
            Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
            List partitionColumnTypes = inputColumns.stream().filter(HiveColumnHandle::isPartitionKey).map(column -> typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
            if (bucketed) {
                partitionColumnTypes.add(IntegerType.INTEGER);
            }
            this.pageIndexer = pageIndexerFactory.createPageIndexer(partitionColumnTypes);
        }

        public int[] partitionPage(Page partitionColumns, Block bucketBlock) {
            if (bucketBlock != null) {
                Block[] blocks = new Block[partitionColumns.getChannelCount() + 1];
                for (int i = 0; i < partitionColumns.getChannelCount(); ++i) {
                    blocks[i] = partitionColumns.getBlock(i);
                }
                blocks[blocks.length - 1] = bucketBlock;
                partitionColumns = new Page(partitionColumns.getPositionCount(), blocks);
            }
            return this.pageIndexer.indexPage(partitionColumns);
        }

        public int getMaxIndex() {
            return this.pageIndexer.getMaxIndex();
        }
    }
}

