/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class HiveMaterializedViewUtils {
    private static final MaterializedViewStatus.MaterializedDataPredicates EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES = new MaterializedViewStatus.MaterializedDataPredicates(ImmutableList.of(), ImmutableList.of());

    private HiveMaterializedViewUtils() {
    }

    public static void validateMaterializedViewPartitionColumns(SemiTransactionalHiveMetastore metastore, MetastoreContext metastoreContext, Table viewTable, ConnectorMaterializedViewDefinition viewDefinition) {
        SchemaTableName viewName = new SchemaTableName(viewTable.getDatabaseName(), viewTable.getTableName());
        Map viewToBaseColumnMap = viewDefinition.getColumnMappingsAsMap();
        if (viewToBaseColumnMap.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Materialized view %s must have at least one column directly defined by a base table column.", viewName));
        }
        List<Column> viewPartitions = viewTable.getPartitionColumns();
        if (viewPartitions.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unpartitioned materialized view is not supported.");
        }
        List baseTables = viewDefinition.getBaseTables().stream().map(baseTableName -> metastore.getTable(metastoreContext, baseTableName.getSchemaName(), baseTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(baseTableName))).collect(ImmutableList.toImmutableList());
        Map baseTablePartitions = baseTables.stream().collect(ImmutableMap.toImmutableMap(table -> new SchemaTableName(table.getDatabaseName(), table.getTableName()), Table::getPartitionColumns));
        for (SchemaTableName baseTable : baseTablePartitions.keySet()) {
            if (HiveMaterializedViewUtils.isCommonPartitionFound(baseTable, (List)baseTablePartitions.get(baseTable), viewPartitions, viewToBaseColumnMap)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Materialized view %s must have at least partition to base table partition mapping for all base tables.", viewName));
        }
    }

    private static boolean isCommonPartitionFound(SchemaTableName baseTable, List<Column> baseTablePartitions, List<Column> viewPartitions, Map<String, Map<SchemaTableName, String>> viewToBaseColumnMap) {
        for (Column viewPartition : viewPartitions) {
            for (Column basePartition : baseTablePartitions) {
                if (!viewToBaseColumnMap.getOrDefault(viewPartition.getName(), Collections.emptyMap()).getOrDefault(baseTable, "").equals(basePartition.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static MaterializedViewStatus.MaterializedDataPredicates getMaterializedDataPredicates(SemiTransactionalHiveMetastore metastore, MetastoreContext metastoreContext, TypeManager typeManager, Table table, DateTimeZone timeZone) {
        List<Column> partitionColumns = table.getPartitionColumns();
        for (Column partitionColumn : partitionColumns) {
            HiveType hiveType = partitionColumn.getType();
            if (hiveType.isSupportedType()) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
        }
        List<HiveColumnHandle> partitionKeyColumnHandles = HiveUtil.getPartitionKeyColumnHandles(table);
        Map partitionTypes = partitionKeyColumnHandles.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> typeManager.getType(column.getTypeSignature())));
        List<String> partitionNames = metastore.getPartitionNames(metastoreContext, table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(table.getDatabaseName(), table.getTableName())));
        ImmutableList.Builder partitionNamesAndValues = ImmutableList.builder();
        for (String partitionName : partitionNames) {
            ImmutableMap.Builder partitionNameAndValuesMap = ImmutableMap.builder();
            Map<String, String> partitions = MetastoreUtil.toPartitionNamesAndValues(partitionName);
            if (partitionColumns.size() != partitions.size()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Expected %d partition key values, but got %d", partitionColumns.size(), partitions.size()));
            }
            partitionTypes.forEach((name, type) -> {
                String value = (String)partitions.get(name);
                if (value == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("partition key value cannot be null for field: %s", name));
                }
                partitionNameAndValuesMap.put(name, HiveUtil.parsePartitionValue(name, value, type, timeZone));
            });
            TupleDomain tupleDomain = TupleDomain.fromFixedValues(partitionNameAndValuesMap.build());
            partitionNamesAndValues.add(tupleDomain);
        }
        return new MaterializedViewStatus.MaterializedDataPredicates((List)((Object)partitionNamesAndValues.build()), (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList()));
    }

    public static MaterializedViewStatus.MaterializedDataPredicates differenceDataPredicates(MaterializedViewStatus.MaterializedDataPredicates leftPredicatesInfo, MaterializedViewStatus.MaterializedDataPredicates rightPredicatesInfo, Map<String, String> rightToLeftPredicatesKeyMap) {
        if (rightToLeftPredicatesKeyMap.isEmpty()) {
            return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
        }
        if (rightPredicatesInfo.isEmpty()) {
            return leftPredicatesInfo;
        }
        HashSet<String> leftMappedCommonKeys = new HashSet<String>();
        HashSet<Object> rightMappedCommonKeys = new HashSet<Object>();
        for (Object rightKey : rightPredicatesInfo.getColumnNames()) {
            String leftKey = rightToLeftPredicatesKeyMap.get(rightKey);
            if (leftKey == null || !leftPredicatesInfo.getColumnNames().contains(leftKey)) continue;
            leftMappedCommonKeys.add(leftKey);
            rightMappedCommonKeys.add(rightKey);
        }
        if (leftMappedCommonKeys.isEmpty()) {
            return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
        }
        HashSet<LinkedHashMap<String, NullableValue>> rightPredicatesMappedToLeftCommonKeys = new HashSet<LinkedHashMap<String, NullableValue>>();
        for (TupleDomain rightPredicate : rightPredicatesInfo.getPredicateDisjuncts()) {
            LinkedHashMap rightPredicateKeyValue = HiveMaterializedViewUtils.getLinkedHashMap(TupleDomain.extractFixedValues(rightPredicate).orElseThrow(() -> new IllegalStateException("rightPredicateKeyValue is not present!")));
            LinkedHashMap<String, NullableValue> rightPredicateMappedToLeftCommonKeys = HiveMaterializedViewUtils.getLinkedHashMap(rightPredicateKeyValue.keySet().stream().filter(rightMappedCommonKeys::contains).collect(TupleDomain.toLinkedMap(rightToLeftPredicatesKeyMap::get, rightPredicateKeyValue::get)));
            rightPredicatesMappedToLeftCommonKeys.add(rightPredicateMappedToLeftCommonKeys);
        }
        ImmutableList.Builder leftMinusRight = ImmutableList.builder();
        for (TupleDomain leftPredicate : leftPredicatesInfo.getPredicateDisjuncts()) {
            LinkedHashMap leftPredicateKeyValue = HiveMaterializedViewUtils.getLinkedHashMap(TupleDomain.extractFixedValues(leftPredicate).orElseThrow(() -> new IllegalStateException("leftPredicateKeyValue is not present!")));
            LinkedHashMap<String, NullableValue> leftPredicateMappedToLeftCommonKeys = HiveMaterializedViewUtils.getLinkedHashMap(leftPredicateKeyValue.keySet().stream().filter(leftMappedCommonKeys::contains).collect(Collectors.toMap(columnName -> columnName, leftPredicateKeyValue::get)));
            if (rightPredicatesMappedToLeftCommonKeys.contains(leftPredicateMappedToLeftCommonKeys)) continue;
            leftMinusRight.add(leftPredicate);
        }
        return new MaterializedViewStatus.MaterializedDataPredicates((List)((Object)leftMinusRight.build()), leftPredicatesInfo.getColumnNames());
    }

    public static MaterializedViewStatus.MaterializedDataPredicates getEmptyMaterializedViewDataPredicates() {
        return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
    }

    private static <K, V> LinkedHashMap<K, V> getLinkedHashMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? (LinkedHashMap)map : new LinkedHashMap<K, V>(map);
    }

    public static Map<SchemaTableName, Map<String, String>> getViewToBasePartitionMap(Table view, List<Table> baseTables, Map<String, Map<SchemaTableName, String>> viewToBaseColumnMap) {
        List viewPartitions = view.getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        Map<SchemaTableName, List> baseTablePartitions = baseTables.stream().collect(Collectors.toMap(table -> new SchemaTableName(table.getDatabaseName(), table.getTableName()), table -> table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
        ImmutableMap.Builder viewToBasePartitionMap = ImmutableMap.builder();
        for (SchemaTableName baseTable : baseTablePartitions.keySet()) {
            HashMap<String, String> partitionMap = new HashMap<String, String>();
            for (String viewPartition : viewPartitions) {
                for (String basePartition : baseTablePartitions.get(baseTable)) {
                    if (!viewToBaseColumnMap.containsKey(viewPartition) || !viewToBaseColumnMap.get(viewPartition).containsKey(baseTable) || !viewToBaseColumnMap.get(viewPartition).get(baseTable).equals(basePartition)) continue;
                    partitionMap.put(viewPartition, basePartition);
                }
            }
            if (partitionMap.isEmpty()) continue;
            viewToBasePartitionMap.put(baseTable, ImmutableMap.copyOf(partitionMap));
        }
        return viewToBasePartitionMap.build();
    }
}

