/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveColumnHandle
implements ColumnHandle {
    public static final int PATH_COLUMN_INDEX = -11;
    public static final String PATH_COLUMN_NAME = "$path";
    public static final HiveType PATH_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final TypeSignature PATH_TYPE_SIGNATURE = PATH_HIVE_TYPE.getTypeSignature();
    public static final int BUCKET_COLUMN_INDEX = -12;
    public static final String BUCKET_COLUMN_NAME = "$bucket";
    public static final HiveType BUCKET_HIVE_TYPE = HiveType.HIVE_INT;
    public static final TypeSignature BUCKET_TYPE_SIGNATURE = BUCKET_HIVE_TYPE.getTypeSignature();
    private static final String UPDATE_ROW_ID_COLUMN_NAME = "$shard_row_id";
    public static final int MAX_PARTITION_KEY_COLUMN_INDEX = -13;
    private final String name;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final ColumnType columnType;
    private final Optional<String> comment;
    private final List<Subfield> requiredSubfields;
    private final Optional<AggregationNode.Aggregation> partialAggregation;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="requiredSubfields") List<Subfield> requiredSubfields, @JsonProperty(value="partialAggregation") Optional<AggregationNode.Aggregation> partialAggregation) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument(hiveColumnIndex >= 0 || columnType == ColumnType.PARTITION_KEY || columnType == ColumnType.SYNTHESIZED || columnType == ColumnType.AGGREGATED, "hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.typeName = Objects.requireNonNull(typeSignature, "type is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.requiredSubfields = Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
        this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
        Preconditions.checkArgument(columnType != ColumnType.AGGREGATED || partialAggregation.isPresent(), "Aggregated column does not have aggregate function");
    }

    public HiveColumnHandle(String name, HiveType hiveType, TypeSignature typeSignature, int hiveColumnIndex, ColumnType columnType, Optional<String> comment, Optional<AggregationNode.Aggregation> partialAggregation) {
        this(name, hiveType, typeSignature, hiveColumnIndex, columnType, comment, ImmutableList.of(), partialAggregation);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    public boolean isPartitionKey() {
        return this.columnType == ColumnType.PARTITION_KEY;
    }

    public boolean isHidden() {
        return this.columnType == ColumnType.SYNTHESIZED;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.name, typeManager.getType(this.typeName), null, this.isHidden());
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Optional<AggregationNode.Aggregation> getPartialAggregation() {
        return this.partialAggregation;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public List<Subfield> getRequiredSubfields() {
        return this.requiredSubfields;
    }

    public ColumnHandle withRequiredSubfields(List<Subfield> subfields) {
        if (HiveColumnHandle.isPushedDownSubfield(this)) {
            return this;
        }
        return new HiveColumnHandle(this.name, this.hiveType, this.typeName, this.hiveColumnIndex, this.columnType, this.comment, subfields, this.partialAggregation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hiveColumnIndex, this.hiveType, this.columnType, this.comment});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.hiveColumnIndex, other.hiveColumnIndex) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals((Object)this.columnType, (Object)other.columnType) && Objects.equals(this.comment, other.comment) && Objects.equals(this.requiredSubfields, other.requiredSubfields);
    }

    public String toString() {
        if (this.requiredSubfields.isEmpty()) {
            return this.name + ":" + this.hiveType + ":" + this.hiveColumnIndex + ":" + (Object)((Object)this.columnType);
        }
        return this.name + ":" + this.hiveType + ":" + this.hiveColumnIndex + ":" + (Object)((Object)this.columnType) + ":" + this.requiredSubfields;
    }

    public static HiveColumnHandle updateRowIdHandle() {
        return new HiveColumnHandle(UPDATE_ROW_ID_COLUMN_NAME, HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), -1, ColumnType.SYNTHESIZED, Optional.empty(), ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle pathColumnHandle() {
        return new HiveColumnHandle(PATH_COLUMN_NAME, PATH_HIVE_TYPE, PATH_TYPE_SIGNATURE, -11, ColumnType.SYNTHESIZED, Optional.empty(), ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle bucketColumnHandle() {
        return new HiveColumnHandle(BUCKET_COLUMN_NAME, BUCKET_HIVE_TYPE, BUCKET_TYPE_SIGNATURE, -12, ColumnType.SYNTHESIZED, Optional.empty(), ImmutableList.of(), Optional.empty());
    }

    public static boolean isPathColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -11;
    }

    public static boolean isBucketColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -12;
    }

    public static Subfield getPushedDownSubfield(HiveColumnHandle column) {
        Preconditions.checkArgument(HiveColumnHandle.isPushedDownSubfield(column), String.format("not a valid pushed down subfield: type=%s, subfields=%s", new Object[]{column.getColumnType(), column.getRequiredSubfields()}));
        return Iterables.getOnlyElement(column.getRequiredSubfields());
    }

    public static boolean isPushedDownSubfield(HiveColumnHandle column) {
        return column.getColumnType() == ColumnType.SYNTHESIZED && column.getRequiredSubfields().size() == 1;
    }

    public static enum ColumnType {
        PARTITION_KEY,
        REGULAR,
        SYNTHESIZED,
        AGGREGATED;

    }
}

