/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class HiveBucketHandle {
    private final List<HiveColumnHandle> columns;
    private final int tableBucketCount;
    private final int readBucketCount;

    @JsonCreator
    public HiveBucketHandle(@JsonProperty(value="columns") List<HiveColumnHandle> columns, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="readBucketCount") int readBucketCount) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.tableBucketCount = tableBucketCount;
        this.readBucketCount = readBucketCount;
    }

    @JsonProperty
    public List<HiveColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getTableBucketCount() {
        return this.tableBucketCount;
    }

    @JsonProperty
    public int getReadBucketCount() {
        return this.readBucketCount;
    }

    public boolean isVirtuallyBucketed() {
        return this.columns.size() == 1 && this.columns.get(0).equals(HiveColumnHandle.pathColumnHandle());
    }

    public static HiveBucketHandle createVirtualBucketHandle(int virtualBucketCount) {
        return new HiveBucketHandle(ImmutableList.of(HiveColumnHandle.pathColumnHandle()), virtualBucketCount, virtualBucketCount);
    }
}

