/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.gcs.GcsConfigurationInitializer;
import com.facebook.presto.hive.s3.S3ConfigurationUpdater;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.SocksSocketFactory;

public class HdfsConfigurationInitializer {
    private final HostAndPort socksProxy;
    private final Duration ipcPingInterval;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final String domainSocketPath;
    private final Configuration resourcesConfiguration;
    private final int fileSystemMaxCacheSize;
    private final S3ConfigurationUpdater s3ConfigurationUpdater;
    private final GcsConfigurationInitializer gcsConfigurationInitialize;
    private final boolean isHdfsWireEncryptionEnabled;
    private int textMaxLineLength;

    @VisibleForTesting
    public HdfsConfigurationInitializer(HiveClientConfig config, MetastoreClientConfig metastoreConfig) {
        this(config, metastoreConfig, ignored -> {}, ignored -> {});
    }

    @Inject
    public HdfsConfigurationInitializer(HiveClientConfig config, MetastoreClientConfig metastoreConfig, S3ConfigurationUpdater s3ConfigurationUpdater, GcsConfigurationInitializer gcsConfigurationInitialize) {
        Objects.requireNonNull(config, "config is null");
        Preconditions.checkArgument(config.getDfsTimeout().toMillis() >= 1L, "dfsTimeout must be at least 1 ms");
        Preconditions.checkArgument(Math.toIntExact(config.getTextMaxLineLength().toBytes()) >= 1, "textMaxLineLength must be at least 1 byte");
        this.socksProxy = metastoreConfig.getMetastoreSocksProxy();
        this.ipcPingInterval = config.getIpcPingInterval();
        this.dfsTimeout = config.getDfsTimeout();
        this.dfsConnectTimeout = config.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = config.getDfsConnectMaxRetries();
        this.domainSocketPath = config.getDomainSocketPath();
        this.resourcesConfiguration = HdfsConfigurationInitializer.readConfiguration(config.getResourceConfigFiles());
        this.fileSystemMaxCacheSize = config.getFileSystemMaxCacheSize();
        this.isHdfsWireEncryptionEnabled = config.isHdfsWireEncryptionEnabled();
        this.textMaxLineLength = Math.toIntExact(config.getTextMaxLineLength().toBytes());
        this.s3ConfigurationUpdater = Objects.requireNonNull(s3ConfigurationUpdater, "s3ConfigurationUpdater is null");
        this.gcsConfigurationInitialize = Objects.requireNonNull(gcsConfigurationInitialize, "gcsConfigurationInitialize is null");
    }

    private static Configuration readConfiguration(List<String> resourcePaths) {
        Configuration result = new Configuration(false);
        for (String resourcePath : resourcePaths) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    public void updateConfiguration(Configuration config) {
        ConfigurationUtils.copy(this.resourcesConfiguration, config);
        config.setClass("net.topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", this.domainSocketPath);
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
        }
        config.setInt("dfs.client.socket-timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
        config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        if (this.isHdfsWireEncryptionEnabled) {
            config.set("hadoop.rpc.protection", "privacy");
            config.setBoolean("dfs.encrypt.data.transfer", true);
        }
        config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
        config.setInt("mapreduce.input.linerecordreader.line.maxlength", this.textMaxLineLength);
        this.s3ConfigurationUpdater.updateConfiguration(config);
        this.gcsConfigurationInitialize.updateConfiguration(config);
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        @Override
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        @Override
        public void reloadCachedMappings() {
        }

        @Override
        public void reloadCachedMappings(List<String> names) {
        }
    }
}

