/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DwrfTableEncryptionProperties
extends TableEncryptionProperties {
    private final String encryptionAlgorithm;
    private final String encryptionProvider;

    private DwrfTableEncryptionProperties(Optional<String> encryptTable, Optional<ColumnEncryptionInformation> columnEncryptionInformation, String encryptionAlgorithm, String encryptionProvider) {
        super(encryptTable, columnEncryptionInformation);
        this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm, "encryptionAlgorithm is null");
        this.encryptionProvider = Objects.requireNonNull(encryptionProvider, "encryptionProvider is null");
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getEncryptionProvider() {
        return this.encryptionProvider;
    }

    @Override
    protected Map<String, String> getFormatSpecificHiveProperties() {
        return ImmutableMap.of("dwrf.encryption.algorithm", this.encryptionAlgorithm, "dwrf.encryption.provider", this.encryptionProvider);
    }

    @Override
    protected Map<String, Object> getFormatSpecificTableProperties() {
        return ImmutableMap.of("dwrf_encryption_algorithm", this.encryptionAlgorithm, "dwrf_encryption_provider", this.encryptionProvider);
    }

    public static DwrfTableEncryptionProperties forTable(String encryptTable, String encryptionAlgorithm, String encryptionProvider) {
        return new DwrfTableEncryptionProperties(Optional.of(encryptTable), Optional.empty(), encryptionAlgorithm, encryptionProvider);
    }

    public static DwrfTableEncryptionProperties forPerColumn(ColumnEncryptionInformation columnEncryptionInformation, String encryptionAlgorithm, String encryptionProvider) {
        return new DwrfTableEncryptionProperties(Optional.empty(), Optional.of(columnEncryptionInformation), encryptionAlgorithm, encryptionProvider);
    }

    public static Optional<DwrfTableEncryptionProperties> fromHiveTableProperties(Map<String, String> properties) {
        String encryptTable = properties.get("encrypt.table");
        String encryptColumns = properties.get("encrypt.columns");
        if (encryptTable != null || encryptColumns != null) {
            if (!properties.containsKey("dwrf.encryption.algorithm") || !properties.containsKey("dwrf.encryption.provider")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_ENCRYPTION_METADATA, String.format("Both %s and %s need to be set for DWRF encryption", "dwrf.encryption.algorithm", "dwrf.encryption.provider"));
            }
            if (encryptTable != null) {
                return Optional.of(DwrfTableEncryptionProperties.forTable(encryptTable, properties.get("dwrf.encryption.algorithm"), properties.get("dwrf.encryption.provider")));
            }
            return Optional.of(DwrfTableEncryptionProperties.forPerColumn(ColumnEncryptionInformation.fromHiveProperty(encryptColumns), properties.get("dwrf.encryption.algorithm"), properties.get("dwrf.encryption.provider")));
        }
        return Optional.empty();
    }
}

