/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.org.apache.http.impl.conn;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hadoop.$internal.org.apache.http.Consts;
import com.facebook.presto.hadoop.$internal.org.apache.http.impl.conn.Wire;
import com.facebook.presto.hadoop.$internal.org.apache.http.io.SessionOutputBuffer;
import com.facebook.presto.hadoop.$internal.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

@.Immutable
public class LoggingSessionOutputBuffer
implements SessionOutputBuffer {
    private final SessionOutputBuffer out;
    private final Wire wire;
    private final String charset;

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire, String charset) {
        this.out = out;
        this.wire = wire;
        this.charset = charset != null ? charset : Consts.ASCII.name();
    }

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire) {
        this(out, wire, null);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.wire.enabled()) {
            this.wire.output(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeLine(CharArrayBuffer buffer) throws IOException {
        this.out.writeLine(buffer);
        if (this.wire.enabled()) {
            String s2 = new String(buffer.buffer(), 0, buffer.length());
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    public void writeLine(String s2) throws IOException {
        this.out.writeLine(s2);
        if (this.wire.enabled()) {
            String tmp = s2 + "\r\n";
            this.wire.output(tmp.getBytes(this.charset));
        }
    }

    public .HttpTransportMetrics getMetrics() {
        return this.out.getMetrics();
    }
}

