/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.org.apache.avro;

import com.facebook.presto.hadoop.$internal.org.apache.avro.Schema;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class SchemaNormalization {
    static final long EMPTY64 = -4513414715797952619L;

    private SchemaNormalization() {
    }

    public static String toParsingForm(Schema s2) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            return SchemaNormalization.build(env, s2, new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fingerprint(String fpName, byte[] data) throws NoSuchAlgorithmException {
        if (fpName.equals("CRC-64-AVRO")) {
            long fp = SchemaNormalization.fingerprint64(data);
            byte[] result = new byte[8];
            for (int i = 0; i < 8; ++i) {
                result[i] = (byte)fp;
                fp >>= 8;
            }
            return result;
        }
        MessageDigest md = MessageDigest.getInstance(fpName);
        return md.digest(data);
    }

    public static long fingerprint64(byte[] data) {
        long result = -4513414715797952619L;
        for (byte b : data) {
            result = result >>> 8 ^ FP64.FP_TABLE[(int)(result ^ (long)b) & 0xFF];
        }
        return result;
    }

    public static byte[] parsingFingerprint(String fpName, Schema s2) throws NoSuchAlgorithmException {
        try {
            return SchemaNormalization.fingerprint(fpName, SchemaNormalization.toParsingForm(s2).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static long parsingFingerprint64(Schema s2) {
        try {
            return SchemaNormalization.fingerprint64(SchemaNormalization.toParsingForm(s2).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Appendable build(Map<String, String> env, Schema s2, Appendable o) throws IOException {
        boolean firstTime = true;
        Schema.Type st = s2.getType();
        switch (st) {
            default: {
                return o.append('\"').append(st.getName()).append('\"');
            }
            case UNION: {
                o.append('[');
                for (Schema b : s2.getTypes()) {
                    if (!firstTime) {
                        o.append(',');
                    } else {
                        firstTime = false;
                    }
                    SchemaNormalization.build(env, b, o);
                }
                return o.append(']');
            }
            case ARRAY: 
            case MAP: {
                o.append("{\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ARRAY) {
                    SchemaNormalization.build(env, s2.getElementType(), o.append(",\"items\":"));
                } else {
                    SchemaNormalization.build(env, s2.getValueType(), o.append(",\"values\":"));
                }
                return o.append("}");
            }
            case ENUM: 
            case FIXED: 
            case RECORD: 
        }
        String name = s2.getFullName();
        if (env.get(name) != null) {
            return o.append(env.get(name));
        }
        String qname = "\"" + name + "\"";
        env.put(name, qname);
        o.append("{\"name\":").append(qname);
        o.append(",\"type\":\"").append(st.getName()).append("\"");
        if (st == Schema.Type.ENUM) {
            o.append(",\"symbols\":[");
            for (String enumSymbol : s2.getEnumSymbols()) {
                if (!firstTime) {
                    o.append(',');
                } else {
                    firstTime = false;
                }
                o.append('\"').append(enumSymbol).append('\"');
            }
            o.append("]");
        } else if (st == Schema.Type.FIXED) {
            o.append(",\"size\":").append(Integer.toString(s2.getFixedSize()));
        } else {
            o.append(",\"fields\":[");
            for (Schema.Field f : s2.getFields()) {
                if (!firstTime) {
                    o.append(',');
                } else {
                    firstTime = false;
                }
                o.append("{\"name\":\"").append(f.name()).append("\"");
                SchemaNormalization.build(env, f.schema(), o.append(",\"type\":")).append("}");
            }
            o.append("]");
        }
        return o.append("}");
    }

    private static class FP64 {
        private static final long[] FP_TABLE = new long[256];

        private FP64() {
        }

        static {
            for (int i = 0; i < 256; ++i) {
                long fp = i;
                for (int j = 0; j < 8; ++j) {
                    long mask = -(fp & 1L);
                    fp = fp >>> 1 ^ 0xC15D213AA4D7A795L & mask;
                }
                FP64.FP_TABLE[i] = fp;
            }
        }
    }
}

