/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.google.common.base;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Ascii;
import com.facebook.presto.hadoop.$internal.com.google.common.base.CharMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@.GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public String to(CaseFormat format, String s2) {
        if (format == null) {
            throw new NullPointerException();
        }
        if (s2 == null) {
            throw new NullPointerException();
        }
        if (format == this) {
            return s2;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (format) {
                    case LOWER_UNDERSCORE: {
                        return s2.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s2.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return Ascii.toLowerCase(s2.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return Ascii.toLowerCase(s2);
                    }
                }
            }
        }
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.wordBoundary.indexIn(s2, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s2.length() + 4 * this.wordSeparator.length());
                out.append(format.normalizeFirstWord(s2.substring(i, j)));
            } else {
                out.append(format.normalizeWord(s2.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        if (i == 0) {
            return format.normalizeFirstWord(s2);
        }
        out.append(format.normalizeWord(s2.substring(i)));
        return out.toString();
    }

    private String normalizeFirstWord(String word) {
        switch (this) {
            case LOWER_CAMEL: {
                return Ascii.toLowerCase(word);
            }
        }
        return this.normalizeWord(word);
    }

    private String normalizeWord(String word) {
        switch (this) {
            case LOWER_HYPHEN: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_UNDERSCORE: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_UNDERSCORE: {
                return Ascii.toUpperCase(word);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String word) {
        int length = word.length();
        if (length == 0) {
            return word;
        }
        return new StringBuilder(length).append(Ascii.toUpperCase(word.charAt(0))).append(Ascii.toLowerCase(word.substring(1))).toString();
    }
}

