/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration.testing;

import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.ConfigurationMetadata;
import com.facebook.airlift.configuration.testing.ConfigAssertions$$;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.testng.Assert;

public final class ConfigAssertions {
    private static final Method GET_RECORDING_CONFIG_METHOD;

    private ConfigAssertions() {
    }

    public static <T> void assertDefaults(Map<String, Object> expectedAttributeValues, Class<T> configClass) {
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        if (!metadata.getAttributes().keySet().containsAll(expectedAttributeValues.keySet())) {
            TreeSet<String> unsupportedAttributes = new TreeSet<String>(expectedAttributeValues.keySet());
            unsupportedAttributes.removeAll(metadata.getAttributes().keySet());
            Assert.fail((String)("Unsupported attributes: " + unsupportedAttributes));
        }
        TreeSet<String> nonDeprecatedAttributes = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() == null) continue;
            nonDeprecatedAttributes.add(attribute.getName());
        }
        if (!nonDeprecatedAttributes.containsAll(expectedAttributeValues.keySet())) {
            TreeSet<String> unsupportedAttributes = new TreeSet<String>(expectedAttributeValues.keySet());
            unsupportedAttributes.removeAll(nonDeprecatedAttributes);
            Assert.fail((String)("Deprecated attributes: " + unsupportedAttributes));
        }
        if (!expectedAttributeValues.keySet().containsAll(nonDeprecatedAttributes)) {
            TreeSet untestedAttributes = new TreeSet(nonDeprecatedAttributes);
            untestedAttributes.removeAll(expectedAttributeValues.keySet());
            Assert.fail((String)("Untested attributes: " + untestedAttributes));
        }
        T actual = ConfigAssertions.newDefaultInstance(configClass);
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(actual, getter);
            Object expectedAttributeValue = expectedAttributeValues.get(attribute.getName());
            Assert.assertEquals((Object)expectedAttributeValue, (Object)actualAttributeValue, (String)attribute.getName());
        }
    }

    public static <T> void assertFullMapping(Map<String, String> properties, T expected) {
        Assert.assertNotNull(properties, (String)"properties");
        Assert.assertNotNull(expected, (String)"expected");
        Class<?> configClass = expected.getClass();
        ConfigurationMetadata<?> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, properties.keySet(), false);
        TreeSet<String> nonDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() == null) continue;
            nonDeprecatedProperties.add(attribute.getInjectionPoint().getProperty());
        }
        if (!properties.keySet().equals(nonDeprecatedProperties)) {
            TreeSet untestedProperties = new TreeSet(nonDeprecatedProperties);
            untestedProperties.removeAll(properties.keySet());
            Assert.fail((String)("Untested properties " + untestedProperties));
        }
        Object actual = ConfigAssertions.newInstance(configClass, properties);
        Object defaultInstance = ConfigAssertions.newDefaultInstance(configClass);
        ConfigAssertions.assertAttributesNotEqual(metadata, actual, defaultInstance);
        ConfigAssertions.assertAttributesEqual(metadata, actual, expected);
    }

    @SafeVarargs
    public static <T> void assertDeprecatedEquivalence(Class<T> configClass, Map<String, String> currentProperties, Map<String, String> ... oldPropertiesList) {
        Assert.assertNotNull(configClass, (String)"configClass");
        Assert.assertNotNull(currentProperties, (String)"currentProperties");
        Assert.assertNotNull(oldPropertiesList, (String)"oldPropertiesList");
        ConfigurationMetadata<T> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        ConfigAssertions.assertPropertiesSupported(metadata, currentProperties.keySet(), false);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            ConfigAssertions.assertPropertiesSupported(metadata, evenOlderProperties.keySet(), true);
        }
        TreeSet<String> knownDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                knownDeprecatedProperties.add(deprecated.getProperty());
            }
        }
        TreeSet<String> suppliedDeprecatedProperties = new TreeSet<String>();
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            suppliedDeprecatedProperties.addAll(evenOlderProperties.keySet());
        }
        if (!suppliedDeprecatedProperties.containsAll(knownDeprecatedProperties)) {
            TreeSet untestedDeprecatedProperties = new TreeSet(knownDeprecatedProperties);
            untestedDeprecatedProperties.removeAll(suppliedDeprecatedProperties);
            Assert.fail((String)("Untested deprecated properties: " + untestedDeprecatedProperties));
        }
        T currentConfiguration = ConfigAssertions.newInstance(configClass, currentProperties);
        for (Map<String, String> evenOlderProperties : oldPropertiesList) {
            T evenOlderConfiguration = ConfigAssertions.newInstance(configClass, evenOlderProperties);
            ConfigAssertions.assertAttributesEqual(metadata, currentConfiguration, evenOlderConfiguration);
        }
    }

    private static void assertPropertiesSupported(ConfigurationMetadata<?> metadata, Set<String> propertyNames, boolean allowDeprecatedProperties) {
        TreeSet<String> supportedProperties = new TreeSet<String>();
        TreeSet<String> nonDeprecatedProperties = new TreeSet<String>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() != null) {
                nonDeprecatedProperties.add(attribute.getInjectionPoint().getProperty());
                supportedProperties.add(attribute.getInjectionPoint().getProperty());
            }
            for (ConfigurationMetadata.InjectionPointMetaData deprecated : attribute.getLegacyInjectionPoints()) {
                supportedProperties.add(deprecated.getProperty());
            }
        }
        if (!supportedProperties.containsAll(propertyNames)) {
            TreeSet<String> unsupportedProperties = new TreeSet<String>(propertyNames);
            unsupportedProperties.removeAll(supportedProperties);
            Assert.fail((String)("Unsupported properties: " + unsupportedProperties));
        }
        if (!allowDeprecatedProperties && !nonDeprecatedProperties.containsAll(propertyNames)) {
            TreeSet<String> deprecatedProperties = new TreeSet<String>(propertyNames);
            deprecatedProperties.removeAll(nonDeprecatedProperties);
            Assert.fail((String)("Deprecated properties: " + deprecatedProperties));
        }
    }

    private static <T> void assertAttributesEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(actual, getter);
            Object expectedAttributeValue = ConfigAssertions.invoke(expected, getter);
            Assert.assertEquals((Object)actualAttributeValue, (Object)expectedAttributeValue, (String)attribute.getName());
        }
    }

    private static <T> void assertAttributesNotEqual(ConfigurationMetadata<T> metadata, T actual, T expected) {
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            Method getter = attribute.getGetter();
            if (getter == null) continue;
            Object actualAttributeValue = ConfigAssertions.invoke(actual, getter);
            Object expectedAttributeValue = ConfigAssertions.invoke(expected, getter);
            Assert.assertNotEquals((Object)actualAttributeValue, (Object)expectedAttributeValue, (String)attribute.getName());
        }
    }

    public static <T> void assertRecordedDefaults(T recordedConfig) {
        $$RecordedConfigData<T> recordedConfigData = ConfigAssertions.getRecordedConfig(recordedConfig);
        Set<Method> invokedMethods = recordedConfigData.getInvokedMethods();
        T config = recordedConfigData.getInstance();
        Class<?> configClass = config.getClass();
        ConfigurationMetadata<?> metadata = ConfigurationMetadata.getValidConfigurationMetadata(configClass);
        TreeMap<String, Object> attributeValues = new TreeMap<String, Object>();
        TreeSet<String> setDeprecatedAttributes = new TreeSet<String>();
        HashSet<Method> validSetterMethods = new HashSet<Method>();
        for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
            if (attribute.getInjectionPoint().getProperty() != null) {
                validSetterMethods.add(attribute.getInjectionPoint().getSetter());
            }
            if (!invokedMethods.contains(attribute.getInjectionPoint().getSetter())) continue;
            if (attribute.getInjectionPoint().getProperty() != null) {
                Object value = ConfigAssertions.invoke(config, attribute.getGetter());
                attributeValues.put(attribute.getName(), value);
                continue;
            }
            setDeprecatedAttributes.add(attribute.getName());
        }
        if (!setDeprecatedAttributes.isEmpty()) {
            Assert.fail((String)("Invoked deprecated attribute setter methods: " + setDeprecatedAttributes));
        }
        if (!validSetterMethods.containsAll(invokedMethods)) {
            HashSet<Method> invalidInvocations = new HashSet<Method>(invokedMethods);
            invalidInvocations.removeAll(validSetterMethods);
            Assert.fail((String)("Invoked non-attribute setter methods: " + invalidInvocations));
        }
        ConfigAssertions.assertDefaults(attributeValues, configClass);
    }

    public static <T> T recordDefaults(Class<T> type) {
        final T instance = ConfigAssertions.newDefaultInstance(type);
        Object proxy = Enhancer.create(type, (Class[])new Class[]{$$RecordingConfigProxy.class}, (Callback)new MethodInterceptor(){
            private final ConcurrentMap<Method, Object> invokedMethods = new MapMaker().makeMap();

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (GET_RECORDING_CONFIG_METHOD.equals(method)) {
                    return new $$RecordedConfigData<Object>(instance, ImmutableSet.copyOf(this.invokedMethods.keySet()));
                }
                this.invokedMethods.put(method, Boolean.TRUE);
                Object result = methodProxy.invoke(instance, args);
                if (result == instance) {
                    return proxy;
                }
                return result;
            }
        });
        return (T)proxy;
    }

    static <T> $$RecordedConfigData<T> getRecordedConfig(T config) {
        if (!(config instanceof $$RecordingConfigProxy)) {
            throw new IllegalArgumentException("Configuration was not created with the recordDefaults method");
        }
        return (($$RecordingConfigProxy)config).$$getRecordedConfig();
    }

    private static <T> T newInstance(Class<T> configClass, Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        return configurationFactory.build(configClass);
    }

    private static <T> T newDefaultInstance(Class<T> configClass) {
        try {
            return configClass.newInstance();
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)String.format("Exception creating default instance of %s", configClass.getName()));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private static <T> Object invoke(T actual, Method getter) {
        try {
            return getter.invoke(actual, new Object[0]);
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)String.format("Exception invoking %s", getter.toGenericString()));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    static {
        try {
            GET_RECORDING_CONFIG_METHOD = $$RecordingConfigProxy.class.getMethod("$$getRecordedConfig", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

