/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.UserState;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@ThreadSafe
public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean isSecurityEnabled(AlluxioConfiguration conf) {
        return SecurityUtils.isAuthenticationEnabled(conf) && SecurityUtils.isAuthorizationEnabled(conf);
    }

    public static boolean isAuthenticationEnabled(AlluxioConfiguration conf) {
        return !conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class).equals((Object)AuthType.NOSASL);
    }

    public static boolean isAuthorizationEnabled(AlluxioConfiguration conf) {
        return conf.getBoolean(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED);
    }

    public static String getOwnerFromGrpcClient(AlluxioConfiguration conf) {
        try {
            User user = AuthenticatedClientUser.get(conf);
            if (user == null) {
                return "";
            }
            return user.getName();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getGroupFromGrpcClient(AlluxioConfiguration conf) {
        try {
            User user = AuthenticatedClientUser.get(conf);
            if (user == null) {
                return "";
            }
            return CommonUtils.getPrimaryGroupName(user.getName(), conf);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getOwner(UserState userState) {
        try {
            return userState.getUser().getName();
        }
        catch (UnauthenticatedException | UnsupportedOperationException e) {
            return "";
        }
    }

    public static String getGroup(UserState userState, AlluxioConfiguration conf) {
        try {
            return CommonUtils.getPrimaryGroupName(SecurityUtils.getOwner(userState), conf);
        }
        catch (IOException | UnsupportedOperationException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginContext createLoginContext(AuthType authType, Subject subject, ClassLoader classLoader, Configuration configuration, CallbackHandler callbackHandler) throws LoginException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            LoginContext loginContext = new LoginContext(authType.getAuthName(), subject, callbackHandler, configuration);
            return loginContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

