/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.conf.AlluxioConfiguration;
import alluxio.hadoop.AlluxioHdfsInputStream;
import alluxio.hadoop.HadoopFileOpener;
import alluxio.hadoop.HadoopUtils;
import alluxio.hadoop.HdfsFileInputStream;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheFileSystem.class);
    private static final Set<String> SUPPORTED_FS = new HashSet<String>(){
        {
            this.add("alluxio");
            this.add("ws");
        }
    };
    private final FileSystem mExternalFileSystem;
    private final HadoopFileOpener mHadoopFileOpener;
    private final LocalCacheFileInStream.FileInStreamOpener mAlluxioFileOpener;
    private CacheManager mCacheManager;
    private Configuration mHadoopConf;
    private AlluxioConfiguration mAlluxioConf;

    public LocalCacheFileSystem(FileSystem fileSystem) {
        this(fileSystem, uriStatus -> fileSystem.open(new Path(uriStatus.getPath())));
    }

    public LocalCacheFileSystem(FileSystem fileSystem, HadoopFileOpener fileOpener) {
        this.mExternalFileSystem = Preconditions.checkNotNull(fileSystem, "filesystem");
        this.mHadoopFileOpener = Preconditions.checkNotNull(fileOpener, "fileOpener");
        this.mAlluxioFileOpener = status -> new AlluxioHdfsInputStream(this.mHadoopFileOpener.open(status));
    }

    @Override
    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        if (!SUPPORTED_FS.contains(uri.getScheme())) {
            throw new UnsupportedOperationException(uri.getScheme() + " is not supported as the external filesystem.");
        }
        super.initialize(uri, conf);
        this.mHadoopConf = conf;
        this.setConf(conf);
        this.mAlluxioConf = HadoopUtils.toAlluxioConf(this.mHadoopConf);
        Properties metricsProperties = new Properties();
        for (Map.Entry<String, String> entry : conf) {
            metricsProperties.setProperty(entry.getKey(), entry.getValue());
        }
        MetricsSystem.startSinksFromConfig(new MetricsConfig(metricsProperties));
        this.mCacheManager = CacheManager.Factory.get(this.mAlluxioConf);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String getScheme() {
        return this.mExternalFileSystem.getScheme();
    }

    @Override
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (this.mCacheManager == null) {
            return this.mExternalFileSystem.open(path, bufferSize);
        }
        URIStatus status = HadoopUtils.toAlluxioUriStatus(this.mExternalFileSystem.getFileStatus(path));
        return this.open(status, bufferSize);
    }

    public FSDataInputStream open(URIStatus status, int bufferSize) throws IOException {
        if (this.mCacheManager == null) {
            return this.mExternalFileSystem.open(HadoopUtils.toPath(new AlluxioURI(status.getPath())), bufferSize);
        }
        return new FSDataInputStream(new HdfsFileInputStream(new LocalCacheFileInStream(status, this.mAlluxioFileOpener, this.mCacheManager, this.mAlluxioConf), this.statistics));
    }

    @Override
    public URI getUri() {
        return this.mExternalFileSystem.getUri();
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.append(f, bufferSize, progress);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.mExternalFileSystem.rename(src, dst);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.mExternalFileSystem.delete(f, recursive);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.mExternalFileSystem.listStatus(f);
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.mExternalFileSystem.setWorkingDirectory(new_dir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.mExternalFileSystem.getWorkingDirectory();
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mExternalFileSystem.mkdirs(f, permission);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.mExternalFileSystem.getFileStatus(f);
    }
}

