/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.DataWriter;
import alluxio.client.block.stream.GrpcDataWriter;
import alluxio.client.block.stream.LocalFileDataWriter;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.grpc.RequestType;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UfsFallbackLocalFileDataWriter
implements DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(UfsFallbackLocalFileDataWriter.class);
    private final DataWriter mLocalFileDataWriter;
    private final FileSystemContext mContext;
    private final WorkerNetAddress mWorkerNetAddress;
    private final long mBlockSize;
    private final long mBlockId;
    private final OutStreamOptions mOutStreamOptions;
    private GrpcDataWriter mGrpcDataWriter;
    private boolean mIsWritingToLocal;

    public static UfsFallbackLocalFileDataWriter create(FileSystemContext context, WorkerNetAddress address, long blockId, long blockSize, OutStreamOptions options) throws IOException {
        try {
            LocalFileDataWriter localFilePacketWriter = LocalFileDataWriter.create(context, address, blockId, blockSize, options);
            return new UfsFallbackLocalFileDataWriter(localFilePacketWriter, null, context, address, blockId, blockSize, options);
        }
        catch (ResourceExhaustedException e) {
            LOG.warn("Fallback to create new block {} in UFS due to a failure of insufficient space on the local worker: {}", (Object)blockId, (Object)e.getMessage());
            GrpcDataWriter grpcDataWriter = GrpcDataWriter.create(context, address, blockId, blockSize, RequestType.UFS_FALLBACK_BLOCK, options);
            return new UfsFallbackLocalFileDataWriter(null, grpcDataWriter, context, address, blockId, blockSize, options);
        }
    }

    UfsFallbackLocalFileDataWriter(DataWriter localFileDataWriter, GrpcDataWriter grpcDataWriter, FileSystemContext context, WorkerNetAddress address, long blockId, long blockSize, OutStreamOptions options) {
        this.mLocalFileDataWriter = localFileDataWriter;
        this.mGrpcDataWriter = grpcDataWriter;
        this.mBlockId = blockId;
        this.mContext = context;
        this.mWorkerNetAddress = address;
        this.mBlockSize = blockSize;
        this.mOutStreamOptions = options;
        this.mIsWritingToLocal = this.mLocalFileDataWriter != null;
    }

    @Override
    public void writeChunk(ByteBuf chunk) throws IOException {
        if (this.mIsWritingToLocal) {
            long pos = this.mLocalFileDataWriter.pos();
            try {
                chunk.retain();
                this.mLocalFileDataWriter.writeChunk(chunk);
                chunk.release();
                return;
            }
            catch (ResourceExhaustedException e) {
                LOG.warn("Fallback to write to UFS for block {} due to a failure of insufficient space on the local worker: {}", (Object)this.mBlockId, (Object)e.getMessage());
                this.mIsWritingToLocal = false;
                try {
                    if (pos == 0L) {
                        this.mLocalFileDataWriter.cancel();
                    } else {
                        this.mLocalFileDataWriter.flush();
                    }
                    this.mGrpcDataWriter = GrpcDataWriter.create(this.mContext, this.mWorkerNetAddress, this.mBlockId, this.mBlockSize, RequestType.UFS_FALLBACK_BLOCK, this.mOutStreamOptions);
                    if (pos > 0L) {
                        this.mGrpcDataWriter.writeFallbackInitRequest(pos);
                    }
                }
                catch (Exception e2) {
                    chunk.release();
                    throw new IOException("Failed to switch to writing block " + this.mBlockId + " to UFS", e2);
                }
            }
        }
        this.mGrpcDataWriter.writeChunk(chunk);
    }

    @Override
    public void flush() throws IOException {
        if (this.mIsWritingToLocal) {
            this.mLocalFileDataWriter.flush();
        } else {
            this.mGrpcDataWriter.flush();
        }
    }

    @Override
    public int chunkSize() {
        if (this.mIsWritingToLocal) {
            return this.mLocalFileDataWriter.chunkSize();
        }
        return this.mGrpcDataWriter.chunkSize();
    }

    @Override
    public long pos() {
        if (this.mIsWritingToLocal) {
            return this.mLocalFileDataWriter.pos();
        }
        return this.mGrpcDataWriter.pos();
    }

    @Override
    public void cancel() throws IOException {
        if (this.mIsWritingToLocal) {
            this.mLocalFileDataWriter.cancel();
        } else {
            if (this.mLocalFileDataWriter != null) {
                this.mLocalFileDataWriter.cancel();
            }
            this.mGrpcDataWriter.cancel();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mIsWritingToLocal) {
            this.mLocalFileDataWriter.close();
        } else {
            if (this.mLocalFileDataWriter != null) {
                this.mLocalFileDataWriter.cancel();
            }
            this.mGrpcDataWriter.close();
        }
    }
}

